package com.bxm.egg.user.info;

import com.bxm.egg.user.model.dto.info.manage.UserInfoManageDTO;
import com.bxm.egg.user.model.dto.manage.info.UserManageListDTO;
import com.bxm.egg.user.model.param.CancelUserParam;
import com.bxm.egg.user.model.param.SetTestUserParam;
import com.bxm.egg.user.model.param.manage.info.UserManageQueryParam;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.dto.IPageModel;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 用户管理service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/27 9:29 上午
 */
public interface UserManageService {

    /**
     * 获取用户列表
     *
     * @param userManageQueryParam 分页查询入参
     * @return 分页列表
     */
    IPageModel<UserManageListDTO> getUserList(UserManageQueryParam userManageQueryParam);

    /**
     * 注销测试用户
     *
     * @param cancelUserParam 入参
     * @return 注销结果
     */
    Message cancelUser(CancelUserParam cancelUserParam);

    /**
     * 查询 用户信息列表
     *
     * @param userId   用户id
     * @param nickname 昵称
     * @return 用户信息
     */
    List<UserInfoManageDTO> selectUserInfoManageList(Long userId, String nickname);

    /**
     * 设置为测试用户
     *
     * @param setTestUserParam 设置用户为测试用户入参
     * @return 返回设置结果
     */
    Message setTestUser(@RequestBody @Validated SetTestUserParam setTestUserParam);
}