package com.bxm.egg.user.info;


import com.bxm.egg.user.model.vo.UserStatisticsBean;

import java.util.Date;
import java.util.List;

/**
 * 用户注册数据统计service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/10/14 7:57 下午
 */
public interface UserRegCounterService {

    /**
     * 统计注册人数
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return 统计数量bean
     */
    List<UserStatisticsBean> regUserCounter(Date startTime, Date endTime);


    /**
     * 统计迁移人数
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return 统计数量bean
     */
    List<UserStatisticsBean> migrationUserCounter(Date startTime, Date endTime);
}