package com.bxm.egg.user.invite;

import com.bxm.egg.user.model.dto.UserInviteBindDTO;
import com.bxm.egg.user.model.dto.UserInviteCollectDTO;
import com.bxm.egg.user.model.dto.UserInviteDTO;
import com.bxm.egg.user.model.dto.InviteCounterDTO;
import com.bxm.egg.user.model.param.UserInviteConterParam;
import com.bxm.egg.user.model.param.UserInvitePageParam;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.egg.user.model.vo.UserInviteOrderVO;
import com.bxm.newidea.component.dto.IPageModel;

import java.util.List;

/**
 * 用户邀请成功的相关记录
 * 用户邀请历史数据过多，最终邀请成功时需要有额外的记录
 *
 * @author liujia
 * @date 2020/05/12 14:32
 */
public interface UserInviteService {


    /**
     * 获取用户邀请的统计信息
     *
     * @param userId 查询的用户ID
     * @return 统计结果
     */
    UserInviteCollectDTO getInviteCollect(Long userId);

    /**
     * 分页查询用户邀请的徒弟列表
     *
     * @param param 分页参数
     * @return 分页结果
     */
    IPageModel<UserInviteDTO> getInviteByPage(UserInvitePageParam param);

    /**
     * 获取用户邀请的最近5个人的头像
     *
     * @param userId 用户ID
     * @return 邀请人头像列表
     */
    List<String> getLastInviteUserHeadImgList(Long userId);

    /**
     * 获取用户的师徒邀请关系
     *
     * @param userId ： 用户id
     * @return 用户的邀请关系，为空返回一个new对象
     */
    UserInviteHistoryBean selectByUserId(Long userId);


    /**
     * 新增：如果不存在新增,状态默认是临时用户
     * 更新：如果状态为非正常[state != 1 ]，则更新
     *
     * @param userId       ： 用户id
     * @param inviteUserId ： 邀请人的用户id
     * @return
     */
    boolean insertOrUpdateUserInviteNotActive(Long userId, Long inviteUserId);

    /**
     * 绑定策略使用的方法
     *
     * @param userInviteBindDTO ： 绑定方法
     * @return ： 成功或者失败
     */
    Boolean insertOrUpdate(UserInviteBindDTO userInviteBindDTO);

    /**
     * 变更用户邀请记录的状态，用于保持邀请记录与用户实际可用状态的一致性
     *
     * @param userId 用户ID
     * @param state  用户的当前状态
     */
    void changeHistoryStatus(Long userId, Byte state);

    /**
     * 获取邀请排行榜前10的数据
     *
     * @param num          : 数量限制
     * @param locationCode : 地区编码
     * @param userIds      : 黑名单用户id 集合
     * @return 邀请排行榜前十名用户数据
     */
    List<UserInviteOrderVO> getUserInviteOrderTen(Integer num, String locationCode, List<Long> userIds);

    /**
     * 根据id获取用户的收徒数量
     *
     * @param userId ： 用户id
     * @return 用户id和用户数量
     */
    UserInviteOrderVO getInviteNumByUserId(Long userId);

    /**
     * 根据用户id获取用户的收徒列表信息
     *
     * @param userId ： 用户id
     * @return ： 列表信息
     */
    List<UserInviteHistoryBean> getListByUid(Long userId);

    /**
     * 获取用户的邀请信息汇总
     *
     * @param param 统计参数
     * @return 邀请信息结果
     */
    InviteCounterDTO getInviteCounter(UserInviteConterParam param);
}
