package com.bxm.egg.user.invite.egg.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.integration.sync.SixEnjoyInviteFoodsIntegrationService;
import com.bxm.egg.user.invite.egg.UserEggInviteService;
import com.bxm.egg.user.mapper.EggInviteMapper;
import com.bxm.egg.user.model.dto.invite.egg.InviteUserListDTO;
import com.bxm.egg.user.model.entity.EggInviteEntity;
import com.bxm.egg.user.model.param.invite.egg.InvitePageParam;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.sync.facade.dto.InviteFoodsDTO;
import com.bxm.sync.facade.param.InviteFoodsParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 蛋蛋佳用户邀请service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/24 5:19 下午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserEggInviteServiceImpl implements UserEggInviteService {

    @Resource
    private EggInviteMapper eggInviteMapper;

    @Resource
    private UserProperties userProperties;

    @Resource
    private final SixEnjoyInviteFoodsIntegrationService sixEnjoyInviteFoodsIntegrationService;

    @Override
    public IPageModel<InviteUserListDTO> inviteList(InvitePageParam invitePageParam) {
        InviteFoodsParam inviteFoodsParam = new InviteFoodsParam();

        BeanUtils.copyProperties(invitePageParam, inviteFoodsParam);

        List<InviteFoodsDTO> todayContributionList = sixEnjoyInviteFoodsIntegrationService.getTodayContribution(inviteFoodsParam);

        //对数据结构进行转换
        List<InviteUserListDTO> resultList = todayContributionList.stream()
                .map(this::convertToInviteUserListDTO).collect(Collectors.toList());
        IPage<InviteUserListDTO> page = new Page<>(invitePageParam.getPageNum(), inviteFoodsParam.getPageNum());

        page.setRecords(resultList);
        return PlusPageModelDTO.build(page);
    }

    private InviteUserListDTO convertToInviteUserListDTO(InviteFoodsDTO item) {

        InviteUserListDTO userListDTO = new InviteUserListDTO();
        userListDTO.setUserId(item.getUserId());
        userListDTO.setNickName(item.getNickname());
        userListDTO.setTodayContributeFoodsNum(item.getFoodsNum());
        userListDTO.setHasEggNum(item.getEggNum());
        userListDTO.setHeadImg(item.getHeadImg());
        return userListDTO;
    }

    @Override
    public Long getInviteUserId(Long userId) {
        LambdaQueryWrapper<EggInviteEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(EggInviteEntity::getBeInviteUserId, userId);
        EggInviteEntity eggInviteEntity = eggInviteMapper.selectOne(queryWrapper);

        if (eggInviteEntity != null) {
            return eggInviteEntity.getUserId();
        }
        return null;
    }

    @Override
    public int countInviteUser(Long userId) {
        LambdaQueryWrapper<EggInviteEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(EggInviteEntity::getUserId, userId);

        return eggInviteMapper.selectCount(queryWrapper);
    }

    @Override
    public List<String> getUserInviteHeadImgList(Long userId) {
        return eggInviteMapper.getInviteUserHeadImg(userId, userProperties.getInviteHeadImgNum());
    }
}