package com.bxm.egg.user.login;

import com.bxm.egg.user.constant.UserLoginTypeEnum;
import com.bxm.egg.user.model.param.login.LoginParam;
import com.bxm.egg.user.model.param.login.LogoutParam;
import com.bxm.egg.user.model.param.login.UserSettingsPasswordParam;
import com.bxm.newidea.component.bo.Message;

/**
 * 用户登录相关逻辑
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/14 10:23 上午
 */
public interface UserLoginService {

    /**
     * 执行登录
     *
     * @param loginParam 登录入参
     * @param loginType  登录类型
     * @return 登录返回结果
     */
    <T extends LoginParam> Message excLogin(T loginParam, UserLoginTypeEnum loginType);

    /**
     * 用户退出登录
     *
     * @param logoutParam 退出登录参数
     */
    void exitLogin(LogoutParam logoutParam);

    /**
     * 修改密码
     *
     * @param userSettingsPasswordParam 修改密码入参
     * @return 是否成功
     */
    Message settingsPassword(UserSettingsPasswordParam userSettingsPasswordParam);


}