package com.bxm.egg.user.medal.cache;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.dto.UserGrantMedalDTO;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/3/8 12:06 下午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserMedalPopCacheManager {

    private RedisListAdapter redisListAdapter;

    /**
     * 将要弹窗的勋章信息放到缓存中
     *
     * @param userId            用户id
     * @param userGrantMedalDTO 用户勋章弹窗信息
     */
    public void addUserMedalPopCache(Long userId, UserGrantMedalDTO userGrantMedalDTO) {
        redisListAdapter.leftPush(buildUserMedalPopKey(userId), userGrantMedalDTO);
    }

    /**
     * 获取需要弹窗的勋章信息
     *
     * @param userId 用户id
     * @return 弹窗的勋章信息
     */
    public UserGrantMedalDTO getUserMedalPopCache(Long userId) {
        return redisListAdapter.rightPop(buildUserMedalPopKey(userId), UserGrantMedalDTO.class);
    }

    private KeyGenerator buildUserMedalPopKey(Long userId) {
        return RedisConfig.USER_POP_MEDAL_DATA.copy().appendKey(userId);
    }

}