package com.bxm.egg.user.medal.msg.listener;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.medal.UserMedalCounterService;
import com.bxm.egg.user.medal.msg.UserMedalProcessor;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Component;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/3/5 6:26 下午
 */
@Slf4j
@Component
@EnableBinding(UserMedalProcessor.class)
@AllArgsConstructor
public class UserMedalCounterListenerService {
    private UserMedalCounterService userMedalCounterService;

    /**
     * 监听binding中的消息
     */
    @StreamListener(UserMedalProcessor.USER_MEDAL_INPUT)
    public void handleHotPostJoinEvent(UserMedalCounterDTO userMedalCounterDTO) {
        log.info("监听到用户改变勋章统计数据消息：{}", JSON.toJSONString(userMedalCounterDTO));
        userMedalCounterService.handleMedalCounterData(userMedalCounterDTO);
    }
}