package com.bxm.egg.user.medal.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.enums.UserMedalCounterTypeEnum;
import com.bxm.egg.user.enums.UserMedalTypeEnum;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.medal.strategy.AbstractMedalCounterStrategy;
import com.bxm.egg.user.model.dto.medal.MedalExtDataDTO;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.egg.user.model.entity.medal.UserMedalInfoEntity;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 签到信息统计策略类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/3/6 10:54 上午
 */
@Slf4j
@Component
@AllArgsConstructor
public class SignCounterStrategy extends AbstractMedalCounterStrategy {

    @Resource
    private UserStatisticsService userStatisticsService;

    @Override
    public void handleCounterData(UserMedalCounterDTO userMedalCounterDTO) {

        //1、获取签到数量勋章的所有信息，判断是否达到条件
        List<UserMedalInfoEntity> medalInfoEntityList =
                achievementMedalCacheManager.getMedalListByType(UserMedalTypeEnum.SIGN_MEDAL.name());

        UserStatisticsEntity userStatisticsEntity =
                userStatisticsService.selectUserStatisticsByUserId(userMedalCounterDTO.getUserId());
        if (userStatisticsEntity == null) {
            log.error("用户统计数据为空，不处理签到勋章数据：{}", userMedalCounterDTO.getUserId());
            return;
        }

        for (UserMedalInfoEntity userMedalInfoEntity : medalInfoEntityList) {
            MedalExtDataDTO medalExtDataDTO = JSON.parseObject(userMedalInfoEntity.getRuleExtData(), MedalExtDataDTO.class);

            if (userStatisticsEntity.getMaxSignNum() >= medalExtDataDTO.getTargetValue()) {
                //如果达到了条件，如果没有获得过，则颁发勋章
                grantAchievementMedal(userMedalCounterDTO.getUserId(), userMedalInfoEntity);
            } else {
                //如果没有达到条件，则不再继续循环直接返回，因为后面等级勋章的条件会更高
                return;
            }
        }
    }

    @Override
    public String counterType() {
        return UserMedalCounterTypeEnum.SIGN_NUM.name();
    }

}