package com.bxm.egg.user.token;

import com.bxm.egg.user.facade.bo.UserTokenBO;
import com.bxm.egg.user.model.dto.token.TokenInfoDTO;
import com.bxm.egg.user.model.param.token.RenewTokenParam;
import com.bxm.newidea.component.param.BasicParam;

/**
 * token相关业务接口
 *
 * @author wzy
 * @date 2021年09月14日15:32:24
 **/
public interface TokenService {

    /**
     * token续约
     *
     * @param param 续约参数
     * @return 新的token，如果为空表示续约失败
     */
    TokenInfoDTO renew(RenewTokenParam param);

    /**
     * 创建用户的accessToken、RefreshToken
     *
     * @param userId 用户ID
     * @param param  请求基础参数
     * @return token信息
     */
    TokenInfoDTO create(Long userId, BasicParam param);

    /**
     * 创建AccessToken
     *
     * @param userId 用户id
     * @return 刷新后的token
     */
    UserTokenBO renewToken(Long userId);
}
