package com.bxm.egg.user.utils;

import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 控制拼接字符的最大长度,仅控制其中的动态拼接部分
 */
public class MaxLengthStringBuilder {

    private int maxLength;

    private List<String> appendStringList;

    private List<Integer> dynamicIndexList;

    private int immutableSize;

    private int index;

    private String placeHolder;

    private MaxLengthStringBuilder(int max) {
        this.maxLength = max;
        this.index = 0;
        appendStringList = Lists.newArrayList();
        dynamicIndexList = Lists.newArrayList();
        placeHolder = "..";
    }

    public static MaxLengthStringBuilder builder(int max) {
        return new MaxLengthStringBuilder(max);
    }

    public MaxLengthStringBuilder appendDynamic(String str) {
        appendStringList.add(str);
        dynamicIndexList.add(index);

        index++;
        return this;
    }

    public MaxLengthStringBuilder appendImmutable(String str) {
        appendStringList.add(str);
        immutableSize += str.length();

        index++;
        return this;
    }

    public MaxLengthStringBuilder placeHolder(String placeHolder) {
        this.placeHolder = placeHolder;
        return this;
    }

    public String build() {
        int residueSize = maxLength - immutableSize;

        StringBuilder builder = new StringBuilder();

        int appendIndex = 0;
        for (String appendStr : appendStringList) {
            if (dynamicIndexList.contains(appendIndex)) {
                if (residueSize <= 0) {
                    builder.append(placeHolder);
                } else {
                    residueSize = residueSize - appendStr.length();

                    if (residueSize < 0) {
                        builder.append(StringUtils.substring(appendStr, 0, appendStr.length() + residueSize));
                        builder.append(placeHolder);
                    } else {
                        builder.append(appendStr);
                    }
                }
            } else {
                builder.append(appendStr);
            }
            appendIndex++;
        }

        return builder.toString();
    }

    @Override
    public String toString() {
        return build();
    }
}