package com.bxm.egg.user.warmlevel.impl.handler;

import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.rule.WarmRule;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 运营把用户帖子下了推荐温暖值发放
 *
 * @author lowi
 * @date 2021/03/03 10:46
 */
@Component
public class PostDownRecommendActionHandler extends AbstractWarmActionHandler {


    @Override
    protected void execAction(WarmActionContext context) {
        //获取此规则需要更改的温暖值
        context.setWarmRuleDetail(getWarmRule(context.getAction().name()));
    }

    @Override
    protected void afterPost(WarmActionContext context) {
    }

    @Override
    public WarmRuleEnum support() {
        return WarmRuleEnum.POST_DOWN_RECOMMEND;
    }

    @Override
    public Class<? extends WarmRule> bindRules() {
        return null;
    }
}
