package com.bxm.egg.user.warmlevel.impl.rule;

import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.WarmRuleEnum;
import com.bxm.egg.user.model.vo.warmlevel.WarmRuleDetail;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.bo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Objects;

/**
 * @author lowi
 * @date 2021/3/3 16:28
 */
@Component
public class CommentRule implements WarmRule {
    @Autowired
    private RedisStringAdapter redisStringAdapter;

    protected UserWarmLevelService userWarmLevelService;

    @Override
    public Message apply(WarmActionContext context) {
        if (null == userWarmLevelService) {
            userWarmLevelService = SpringContextHolder.getBean(UserWarmLevelService.class);
        }
        WarmRuleDetail warmRule = userWarmLevelService.getWarmRule(WarmRuleEnum.COMMENT.name());
        KeyGenerator keyGenerator = RedisConfig.USER_COMMENT_WARM.copy().appendKey(DateUtils.formatDate(new Date())).appendKey(context.getUserId());
        Integer num = redisStringAdapter.get(keyGenerator, Integer.class);
        if (Objects.nonNull(num) && warmRule.getMaxGainValue() <= num) {
            return Message.build(false).setMessage("已发放过帖子评论温暖值奖励");
        }
        return Message.build(true);
    }

    @Override
    public boolean retryOnFailed() {
        return false;
    }
}
