package com.bxm.egg.user.account.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.account.UserAccountService;
import com.bxm.egg.user.facade.enums.OperateTypeEnum;
import com.bxm.egg.user.integration.sync.SixEnjoyDataStatisticsIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyUserAccountIntegrationService;
import com.bxm.egg.user.mapper.UserAccountMapper;
import com.bxm.egg.user.model.dto.account.UserBaseAccountInfoDTO;
import com.bxm.egg.user.model.entity.UserAccountEntity;
import com.bxm.sync.facade.dto.UserCouponsStatisticsDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 用户账户服务实现类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/16 1:09 下午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserAccountServiceImpl implements UserAccountService {

    private final UserAccountMapper userAccountMapper;

    private final SixEnjoyDataStatisticsIntegrationService sixEnjoyDataStatisticsIntegrationService;

    private final SixEnjoyUserAccountIntegrationService sixEnjoyUserAccountIntegrationService;

    @Override
    public UserBaseAccountInfoDTO baseInfo(Long userId) {
        UserAccountEntity userAccountEntity = getUserAccountInfo(userId);
        UserCouponsStatisticsDTO couponsStatistics = sixEnjoyDataStatisticsIntegrationService.getCouponsStatistics(userId);

        return UserBaseAccountInfoDTO.builder()
                .userId(userId)
                .usableEggCouponNum(couponsStatistics.getEggCoupon())
                .usableEggNum(userAccountEntity.getUsableEgg())
                .build();
    }

    @Override
    public UserAccountEntity getUserAccountInfo(Long userId) {
        LambdaQueryWrapper<UserAccountEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(UserAccountEntity::getUserId, userId);

        UserAccountEntity userAccountEntity = userAccountMapper.selectOne(queryWrapper);

        if (userAccountEntity == null) {
            return buildInvalidUserAccount(userId);
        }

        return userAccountEntity;
    }

    @Override
    public Boolean operateEgg(Long userId, Integer num, Integer type) {
        if (Objects.equals(OperateTypeEnum.INCREASE.getCode(), type)) {
            return sixEnjoyUserAccountIntegrationService.addEggsNum(userId, num, "火啦测试操作");
        }

        if (Objects.equals(OperateTypeEnum.REDUCE.getCode(), type)) {
            return sixEnjoyUserAccountIntegrationService.subEggsNum(userId, num, "火啦测试操作");
        }

        return false;
    }

    @Override
    public Boolean operateFoods(Long userId, Integer num, Integer type) {
        if (Objects.equals(OperateTypeEnum.INCREASE.getCode(), type)) {
            return sixEnjoyUserAccountIntegrationService.addFoodsNum(userId, num, "火啦测试操作");
        }

        if (Objects.equals(OperateTypeEnum.REDUCE.getCode(), type)) {
            return sixEnjoyUserAccountIntegrationService.subFoodsNum(userId, num, "火啦测试操作");
        }

        return false;
    }

    private UserAccountEntity buildInvalidUserAccount(Long userId) {
        UserAccountEntity userAccountEntity = new UserAccountEntity();
        userAccountEntity.setId(0L);
        userAccountEntity.setUserId(userId);
        userAccountEntity.setMoney(new BigDecimal("0"));
        userAccountEntity.setEggCoin(new BigDecimal("0"));
        userAccountEntity.setCompanyMoney(new BigDecimal("0"));
        userAccountEntity.setScore(0);
        userAccountEntity.setAllFoods(0);
        userAccountEntity.setUsableFoods(0);
        userAccountEntity.setUsedFoods(0);
        userAccountEntity.setAllEgg(0);
        userAccountEntity.setUsableEgg(0);
        userAccountEntity.setUsedEgg(0);
        userAccountEntity.setCreateTime(LocalDateTime.now());
        userAccountEntity.setModifyTime(LocalDateTime.now());

        return userAccountEntity;
    }
}