package com.bxm.egg.user.attribute;


import com.bxm.egg.user.model.dto.UserAccountMaterialGuideDTO;
import com.bxm.egg.user.model.dto.UserPersonalInfoDTO;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.entity.UserInformationEntity;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import com.bxm.egg.user.model.param.*;
import com.bxm.newidea.component.bo.Message;

/**
 * 用户个人资料相关接口
 *
 * @author wzy
 * @date 2021年09月16日13:12:54
 */
public interface UserPersonalInfoService {

    /**
     * 用途：用户可自定义自己的标签，如果和默认标签重复，则以自定义标签为准
     * 场景：用户可以在<我的标签>和<个人主页>点击添加进入<创建标签>页面，从而增加新标签-
     *
     * @param customTagParam 自己看
     * @return 返回刚刚自定义的标签方便回显
     */
    Message saveCustomTag(CustomTagParam customTagParam);

    /**
     * 更新用户标签信息
     *
     * @param userTagParam 标签信息入参
     * @return 更新结果
     */
    Message doUpdateUserTag(UserTagParam userTagParam);

    /**
     * 更新用户头像信息
     *
     * @param userHeadImgParam 入参
     * @return 更新结果
     */
    Message doUpdateHeadImg(UserHeadImgParam userHeadImgParam);

    /**
     * 更新昵称信息
     *
     * @param userNicknameParam 昵称入参
     * @return 更新结果
     */
    Message doUpdateNickname(UserNicknameParam userNicknameParam);

    /**
     * 更新生日信息
     *
     * @param userBirthParam 入参
     * @return 更新结果
     */
    Message doUpdateBirth(UserBirthParam userBirthParam);

    /**
     * 更新家乡信息
     *
     * @param userHomeTownParam 入参
     * @return 更新结果
     */
    Message doUpdateHometown(UserHomeTownParam userHomeTownParam);

    /**
     * 更新情感状态
     *
     * @param userEmotionParam 入参
     * @return 更新结果
     */
    Message doUpdateEmotion(UserEmotionParam userEmotionParam);

    /**
     * 更新行业信息
     *
     * @param userJobParam 入参
     * @return 更新结果
     */
    Message doUpdateJob(UserJobParam userJobParam);

    /**
     * 更新个人简介
     *
     * @param userIntroductionParam 入参
     * @return 更新信息
     */
    Message doUpdatePersonalProfile(UserIntroductionParam userIntroductionParam);

    /**
     * 更新用户性别
     *
     * @param userSexParam 入参
     * @return 更新信息
     */
    Message doUpdateUserSex(UserSexParam userSexParam);


    /**
     * 更新用户的微信号码
     *
     * @param userWechatParam 入参
     * @return 更新信息
     */
    Message doUpdateUserWechat(UserWechatParam userWechatParam);

    /**
     * 获取个人资料信息
     *
     * @param userId 用户id
     * @return 个人信息
     */
    UserPersonalInfoDTO getUserPersonalInfo(Long userId);

    /**
     * 用途：在用户创建时初始化用户的完善资料程度情况 这个方法别看，很蠢
     *
     * @param userInfoEntity        用户信息
     * @param userInformationEntity 用户资料信息
     * @param userLocationEntity    用户定位信息
     */
    Long initUserInfoCompleteStatus(UserInfoEntity userInfoEntity,
                                    UserInformationEntity userInformationEntity,
                                    UserLocationEntity userLocationEntity);


    /**
     * 用途：是否弹出完善资料的弹窗
     */
    Boolean getCompleteInformationWindow(Long userId);


    UserAccountMaterialGuideDTO getAccountMaterialGuide(Long userId);

}
