package com.bxm.egg.user.constant;

import lombok.Getter;

/**
 * 用户登录类型枚举
 */
@Getter
public enum UserLoginTypeEnum {
    /**
     * 微信登录
     */
    WX(0),
    /**
     * 一键登录
     */
    ONE_KEY(1),
    /**
     * 短信登录
     */
    SMS(2),
    /**
     * 微信绑定手机号登录
     */
    WECHAT_BIND_MOBILE_LOGIN(3),

    /**
     * 账号密码登录
     */
    ACCOUNT(4),

    /**
     * 手机号注册并登录
     */
    PHONE_REGISTER(5),

    /**
     * 设计密码并登录
     */
    SETTINGS_PASSWORD_LOGIN(6),

    /**
     * 微信一键绑定手机号登录
     */
    WECHAT_BIND_MOBILE_ONE_KEY_LOGIN(7);

    /**
     * 登录的类型
     */
    private int type;


    UserLoginTypeEnum(int type) {
        this.type = type;
    }
}
