package com.bxm.egg.user.equitylevelmedal;


import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelInfoDTO;
import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelMedalInfoDTO;

import java.util.List;

/**
 * @author lowi
 * @date 2021/3/5 15:45
 */
public interface UserEquityLevelMedalService {

    /**
     * 根据用户id获取用户等级权益勋章信息
     *
     * @param userIdList 用户id
     * @return 信息
     */
    List<UserEquityLevelMedalInfoDTO> getEquityLevelMedalList(List<Long> userIdList);

    /**
     * 根据用户id获取用户等级权益信息
     *
     * @param userId 用户id
     * @return 信息
     */
    UserEquityLevelMedalInfoDTO getEquityLevelMedalInfo(Long userId);

    /**
     * 根据用户id获取用户等级权益信息
     *
     * @param userIdList    用户id
     * @param showLevelRule 用户达到一定等级，可在本地圈显示等级（默认不传就不做控制，传了就控制）
     * @return 信息
     */
    List<UserEquityLevelInfoDTO> getEquityLevelInfoList(List<Long> userIdList, Boolean showLevelRule);

    /**
     * 获取用户勋章数量（勋章数量等于：成就勋章的数量（同一个等级算一个）+ 定制勋章的数量）
     *
     * @param userId 用户id
     * @return 勋章总数
     */
    int getUserMedalNum(Long userId);

}
