package com.bxm.egg.user.equitylevelmedal.impl;

import com.bxm.egg.user.enums.WarmValueEquityEnum;
import com.bxm.egg.user.equitylevelmedal.UserEquityLevelMedalService;
import com.bxm.egg.user.mapper.medal.UserMedalRelationInfoMapper;
import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.WearMedalDTO;
import com.bxm.egg.user.model.dto.warmlevel.UserWarmLevelInfoDTO;
import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelInfoDTO;
import com.bxm.egg.user.model.equitylevelmedal.UserEquityLevelMedalInfoDTO;
import com.bxm.egg.user.model.vo.medal.SinglePreviewMedalVO;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author lowi
 * @date 2021/3/5 15:45
 */
@Service
@Slf4j
public class UserEquityLevelMedalServiceImpl implements UserEquityLevelMedalService {

    @Autowired
    private UserWarmLevelService userWarmLevelService;

    @Autowired
    private UserMedalRelationInfoMapper userMedalRelationInfoMapper;

    @Override
    public List<UserEquityLevelMedalInfoDTO> getEquityLevelMedalList(List<Long> userIdList) {
        return userIdList.stream().map(this::builderEquityLevelMedal).collect(Collectors.toList());
    }

    @Override
    public List<UserEquityLevelInfoDTO> getEquityLevelInfoList(List<Long> userIdList, Boolean showLevelRule) {
        return userIdList.stream().map(userId -> {
            UserEquityLevelInfoDTO equityLevelInfoDTO = UserEquityLevelInfoDTO.builder().build();
            equityLevelInfoDTO.setUserId(userId);
            UserWarmLevelInfoDTO userWarmInfoCache = userWarmLevelService.getUserWarmInfoCache(userId);
            if (showLevelRule) {
                String[] equityType = userWarmInfoCache.getEquityDTO().getEquityType();
                if (Objects.nonNull(equityType) && equityType.length > 0) {
                    List<String> equityList = Arrays.asList(equityType);
                    equityLevelInfoDTO.setUserEquityDTO(equityList.contains(WarmValueEquityEnum.LEVEL_SHOW.name()) ?
                            userWarmInfoCache.getEquityDTO() : UserEquityDTO.builder().showLevel(false).build());
                }
            } else {
                equityLevelInfoDTO.setUserEquityDTO(userWarmInfoCache.getEquityDTO());
            }
            return equityLevelInfoDTO;
        }).collect(Collectors.toList());
    }

    @Override
    public UserEquityLevelMedalInfoDTO getEquityLevelMedalInfo(Long userId) {
        return builderEquityLevelMedal(userId);
    }

    private UserEquityLevelMedalInfoDTO builderEquityLevelMedal(Long userId) {
        UserWarmLevelInfoDTO userWarmInfoCache = userWarmLevelService.getUserWarmInfoCache(userId);

        //获取勋章
        List<SinglePreviewMedalVO> allWearMedalInfoList = userMedalRelationInfoMapper.getAllWearMedalInfo(userId);

        List<WearMedalDTO> wearMedalDTOList = allWearMedalInfoList.stream().map(item -> {
            WearMedalDTO wearMedalDTO = new WearMedalDTO();
            BeanUtils.copyProperties(item, wearMedalDTO);
            return wearMedalDTO;
        }).collect(Collectors.toList());
        return UserEquityLevelMedalInfoDTO.builder()
                .userEquityDTO(userWarmInfoCache.getEquityDTO())
                .userId(userId)
                .wearMedalDTOList(wearMedalDTOList)
                .build();
    }

    @Override
    public int getUserMedalNum(Long userId) {
        //用户勋章数量=成就勋章+定制勋章
        int achievementMedalNum = userMedalRelationInfoMapper.countUserAchievementMedalNum(userId);
        int customMedalNum = userMedalRelationInfoMapper.countUserCustomMedalNum(userId);

        return achievementMedalNum + customMedalNum;
    }
}
