package com.bxm.egg.user.facade;

import com.bxm.egg.user.facade.bo.UserLocationBO;
import com.bxm.egg.user.facade.service.UserLocationFacadeService;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.model.entity.UserLocationEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/29 5:32 下午
 */
@DubboService(protocol = {"dubbo"}, version = "1.0.0")
@Slf4j
public class UserLocationFacadeServiceImpl implements UserLocationFacadeService {

    @Resource
    private UserLocationService userLocationService;

    @Override
    public UserLocationBO getUserLocationInfo(Long userId) {
        UserLocationEntity userLocationInfo = userLocationService.getUserLocationByUserId(userId);

        UserLocationBO userLocationBO = new UserLocationBO();
        if (Objects.nonNull(userLocationInfo)) {
            userLocationBO.setLocationCode(userLocationInfo.getLocationCode());
            userLocationBO.setLocationName(userLocationInfo.getLocationName());
        }

        return userLocationBO;
    }
}