package com.bxm.egg.user.facade;

import com.bxm.egg.user.facade.param.UserStatisticsOperateParam;
import com.bxm.egg.user.facade.service.UserStatisticsFacadeService;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.newidea.component.bo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/28 7:26 下午
 */
@DubboService(protocol = {"dubbo"}, version = "1.0.0")
@Slf4j
@AllArgsConstructor
public class UserStatisticsFacadeServiceImpl implements UserStatisticsFacadeService {

    private UserStatisticsService userStatisticsService;

    @Override
    public Message operateUserStatistics(UserStatisticsOperateParam param) {
        return userStatisticsService.operateUserStatistics(param);
    }
}