package com.bxm.egg.user.facade;

import com.bxm.egg.user.facade.dto.UserBindWxFacadeDTO;
import com.bxm.egg.user.facade.service.UserWechatGrantFacadeService;
import com.bxm.egg.user.info.UserWechatGrantService;
import com.bxm.egg.user.model.dto.info.UserBindWxDTO;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;

import javax.annotation.Resource;

/**
 * @author lowi
 * @date 2021/11/12 16:46
 */
@DubboService(protocol = {"dubbo"}, version = "1.0.0")
@Slf4j
public class UserWechatGrantFacadeServiceImpl implements UserWechatGrantFacadeService {

    @Resource
    private UserWechatGrantService userWechatGrantService;

    @Override
    public UserBindWxFacadeDTO getUserHasBindWx(Long userId, Long decvId) {

        UserBindWxDTO userHasBindWx = userWechatGrantService.getUserHasBindWx(userId, decvId);
        if (userHasBindWx == null) {
            return null;
        }
        UserBindWxFacadeDTO userBindWxFacadeDTO = new UserBindWxFacadeDTO();
        userBindWxFacadeDTO.setFoodsNum(userHasBindWx.getFoodsNum());
        userBindWxFacadeDTO.setIsBind(userHasBindWx.getIsBind());
        return userBindWxFacadeDTO;
    }
}
