package com.bxm.egg.user.info;

import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.newidea.component.param.BasicParam;

/**
 * 用户扩展服务
 *
 * @author wzy
 * @date 2021年09月14日17:08:32
 **/
public interface UserExtendService {

    /**
     * 处理第三方的头像，将其上传到自己的文件服务器，防止第三方文件失效
     *
     * @param imageUrl 原始图片地址
     * @param userId   图片所属用户ID
     * @return 处理后的图片地址
     */
    String uploadWechatImage(String imageUrl, Long userId);


    /**
     * 初始化用户扩展数据
     *
     * @param newUser 用户信息
     */
    void initUserExtendData(UserInfoEntity newUser);

    /**
     * 初始化资料完成度
     *
     * @param userId 用户id
     */
    void initComplete(Long userId);
}
