package com.bxm.egg.user.info;

import com.bxm.egg.user.model.bo.UserCacheInfoBO;

import java.util.Collection;
import java.util.List;

/**
 * 用户缓存service
 * <p>
 * 什么时候要用这个类呢？
 * 展示其他用户的数据时，实时性没有那么高，当前用户并不关系其他用户的用户数据的实时性
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/17 2:48 下午
 */
public interface UserInfoCacheService {

    /**
     * 从缓存中加载用户信息
     *
     * @param userId 用户ID
     * @return 用户缓存信息
     */
    UserCacheInfoBO load(Long userId);

    /**
     * 批量获取用户信息
     *
     * @param userIds 用户id集合
     * @return 用户信息集合
     */
    List<UserCacheInfoBO> getBatchUserInfo(Collection<Long> userIds);

    /**
     * 清空指定用户的缓存
     *
     * @param userId 用户id
     */
    void clearUserCache(Long userId);
}