package com.bxm.egg.user.info;

import com.bxm.egg.user.constant.UserStateEnum;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.canel.CancelUserParam;
import com.bxm.sync.facade.dto.UserRegisterDTO;
import com.bxm.sync.facade.param.UserRegisterParam;

import java.util.Optional;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/14 2:08 下午
 */
public interface UserInfoService {

    /**
     * 注销用户
     *
     * @param cancelUserParam 入参
     * @return 是否注销成功
     */
    Boolean cancelUser(CancelUserParam cancelUserParam);

    /**
     * 创建一个用户ID
     *
     * @param userRegisterParam 注册参数
     * @return 唯一的用户ID
     */
    UserRegisterDTO generateUserId(UserRegisterParam userRegisterParam);

    /**
     * 更新用户状态
     *
     * @param userId 用户ID
     * @param status 用户更新后的状态
     */
    void updateStatus(Long userId, UserStateEnum status);

    /**
     * 用户UnionId是否存在，存在返回用户id
     *
     * @param unionId unionId
     * @return 用户id
     */
    Optional<Long> userUnionIdExist(String unionId);

    /**
     * 用户手机号码是否存在，存在返回用户id
     *
     * @param phone 手机号码
     * @return 用户id
     */
    Optional<Long> userPhoneExist(String phone);

    /**
     * 用户名是否存在，存在返回用户id
     *
     * @param username 用户名
     * @return 用户id
     */
    Optional<Long> userUsernameExist(String username);

    /**
     * 验证用户登录的密码是否正确
     *
     * @param userId   用户id
     * @param username 用户名
     * @param password 密码
     * @return 是否正确
     */
    boolean checkUserPassword(Long userId,
                              String username,
                              String password);

    /**
     * 更新用户密码
     *
     * @param userId   用户id
     * @param password 密码
     */
    void updateUserPassword(Long userId,
                            String password);

    /**
     * 是否设置密码
     *
     * @param username 用户名
     * @return 是否设置密码
     */
    boolean hasSettingPassword(String username);

    /**
     * 为用户绑定手机号
     *
     * @param userId 用户id
     * @param phone  手机号码
     */
    void bindPhone(Long userId, String phone);

    /**
     * 绑定用户名
     *
     * @param userId   用户id
     * @param username 用户名
     */
    void bindUsername(Long userId, String username);

    /**
     * 根据用户id查询完整用户信息
     *
     * @param userId 用户id
     * @return 用户信息
     */
    UserInfoEntity selectUserById(Long userId);

    /**
     * 根据用户id查询完整用户信息【包含被删除的用户】
     *
     * @param userId 用户id
     * @return 用户信息
     */
    UserInfoEntity selectAllUserById(Long userId);

    /**
     * 更新用户信息
     *
     * @param userInfoEntity 用户信息
     * @return 影响行数
     */
    int updateUserInfo(UserInfoEntity userInfoEntity);

    /**
     * 用户头像修复
     * @return 是否成功
     */
    Boolean headImgRepair();
}

