package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.egg.mq.common.constant.TemplateTypeEnum;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.model.dto.PushPayloadInfo;
import com.bxm.egg.mq.common.model.dto.PushReceiveScope;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.enums.UserCoverStatusEnum;
import com.bxm.egg.user.enums.WarmValueEquityEnum;
import com.bxm.egg.user.info.UserCoverService;
import com.bxm.egg.user.integration.MessageFacadeIntegrationService;
import com.bxm.egg.user.mapper.UserCoverMapper;
import com.bxm.egg.user.model.UserEquityDTO;
import com.bxm.egg.user.model.dto.UserCoverDTO;
import com.bxm.egg.user.model.dto.UserCoverListDTO;
import com.bxm.egg.user.model.dto.warmlevel.UserWarmLevelInfoDTO;
import com.bxm.egg.user.model.param.UserCenterCoverParam;
import com.bxm.egg.user.model.param.UserCoverAuditParam;
import com.bxm.egg.user.model.param.UserCoverListParam;
import com.bxm.egg.user.model.vo.UserCover;
import com.bxm.egg.user.warmlevel.UserWarmLevelService;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.lang.Boolean.FALSE;

/**
 * 用户封面service实现类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/17 9:38 上午
 */
@Slf4j
@Service
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class UserCoverServiceImpl implements UserCoverService {

    private final RedisStringAdapter redisStringAdapter;

    private final UserWarmLevelService userWarmLevelService;

    private final UserCoverMapper userCoverMapper;

    private final MessageFacadeIntegrationService messageSender;

    @Override
    public Message uploadCover(UserCenterCoverParam param) {
        UserWarmLevelInfoDTO userWarmInfoCache = userWarmLevelService.getUserWarmInfoCache(param.getUserId());
        if (Objects.isNull(userWarmInfoCache)) {
            return Message.build(FALSE).setMessage("用户信息不存在");
        }
        UserEquityDTO equityDTO = userWarmInfoCache.getEquityDTO();
        if (Objects.isNull(equityDTO)) {
            return Message.build(FALSE).setMessage("用户等级信息不存在");
        }
        String[] equityType = equityDTO.getEquityType();
        if (Objects.isNull(equityType)) {
            return Message.build(FALSE).setMessage("用户等级不符合更换封面");
        }
        if (!Arrays.asList(equityType).contains(WarmValueEquityEnum.USER_COVER.name())) {
            return Message.build(FALSE).setMessage("用户等级不符合更换封面");
        }
        UserCover lastCoverInfoByStatus = userCoverMapper.getLastCoverInfoByStatus(param.getUserId(), 0);
        if (Objects.nonNull(lastCoverInfoByStatus)) {
            return Message.build(FALSE).setMessage("已有待审核的封面，请审核后再做修改");
        }
        UserCover userCover = new UserCover();
        userCover.setCoverUrl(param.getUrl());
        userCover.setCreateTime(new Date());
        userCover.setId(SequenceHolder.nextLongId());
        userCover.setUserId(param.getUserId());
        userCover.setNickname(userWarmInfoCache.getNickname());
        userCover.setStatus(0);
        userCoverMapper.insertSelective(userCover);

        UserCover auditSuccess = userCoverMapper.getLastCoverInfoByStatus(param.getUserId(), 1);
        UserCoverDTO userCoverDTO = new UserCoverDTO();
        userCoverDTO.setUserId(param.getUserId());
        if (Objects.nonNull(auditSuccess)) {
            userCoverDTO.setAuditCover(auditSuccess.getCoverUrl());
        }
        userCoverDTO.setNoAuditCover(param.getUrl());
        redisStringAdapter.set(userCoverCache(param.getUserId()), userCoverDTO);
        return Message.build(true).setMessage("请等待工作人员审核");
    }


    private KeyGenerator userCoverCache(Long userId) {
        return RedisConfig.USER_COVER_INFO.copy().appendKey(userId);
    }

    @Override
    public Message auditUserCover(UserCoverAuditParam param) {
        UserCover userCover = userCoverMapper.selectByPrimaryKey(param.getId());
        if (Objects.isNull(userCover)) {
            return Message.build(false).setMessage("审核信息不存在");
        }
        if (Objects.equals(userCover.getStatus(), UserCoverStatusEnum.AUDIT_PASS.getStatus())) {
            return Message.build(false).setMessage("封面已通过审核，不能再修改状态");
        }
        if (Objects.equals(userCover.getStatus(), param.getStatus())) {
            return Message.build(false).setMessage("输入状态错误");
        }
        userCover.setStatus(param.getStatus());
        userCover.setRemark(param.getRemake());
        userCover.setModifyTime(new Date());
        userCoverMapper.updateByPrimaryKeySelective(userCover);
        if (Objects.equals(param.getStatus(), UserCoverStatusEnum.AUDIT_PASS.getStatus())) {
            UserCoverDTO userCoverDTO = new UserCoverDTO();
            userCoverDTO.setUserId(userCover.getUserId());
            userCoverDTO.setAuditCover(userCover.getCoverUrl());
            userCoverDTO.setNoAuditCover(null);
            redisStringAdapter.set(userCoverCache(userCover.getUserId()), userCoverDTO);
        } else {
            //发推送
            PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.OPEN_URL);
            info.setProtocol("egg://mine/userHomePage?userId=" + userCover.getUserId() + "&toast=0");
            PushMessage message = PushMessage.build();
            message.setTitle("封面审核失败");
            message.setContent("经举报和审核，你的封面图片违反蛋蛋佳管理规范，请重新上传，感谢你的理解");
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle(userCover.getUserId()));
            message.setPayloadInfo(info);
            messageSender.sendPushMessage(message);

            UserCover auditSuccess = userCoverMapper.getLastCoverInfoByStatus(userCover.getUserId(), 1);
            UserCoverDTO userCoverDTO = new UserCoverDTO();
            userCoverDTO.setUserId(userCover.getUserId());
            if (Objects.nonNull(auditSuccess)) {
                userCoverDTO.setAuditCover(auditSuccess.getCoverUrl());
            }
            userCoverDTO.setNoAuditCover(null);
            redisStringAdapter.set(userCoverCache(userCover.getUserId()), userCoverDTO);
        }
        return Message.build(true);
    }

    @Override
    public IPageModel<UserCoverListDTO> getUserCoverList(UserCoverListParam param) {
        IPage<UserCover> queryParam = new Page<>(param.getPageNum(), param.getPageSize());
        IPage<UserCover> userCovers = userCoverMapper.getUserCoverList(queryParam, param);


        List<UserCoverListDTO> userCoverListDTOS = userCovers.getRecords()
                .stream().map(this::toUserCoverListDTO).collect(Collectors.toList());

        PlusPageModelDTO resultList = PlusPageModelDTO.build(userCovers);

        resultList.changeList(userCoverListDTOS);

        return resultList;
    }

    private UserCoverListDTO toUserCoverListDTO(UserCover userCover) {
        UserCoverListDTO userCoverListDTO = new UserCoverListDTO();
        userCoverListDTO.setAddTime(userCover.getCreateTime());
        userCoverListDTO.setId(userCover.getId());
        userCoverListDTO.setNickname(userCover.getNickname());
        userCoverListDTO.setStatus(userCover.getStatus());
        userCoverListDTO.setUserId(userCover.getUserId());
        userCoverListDTO.setUrl(userCover.getCoverUrl());
        return userCoverListDTO;
    }
}