package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.attribute.UserPersonalInfoService;
import com.bxm.egg.user.dto.LocationDTO;
import com.bxm.egg.user.info.UserExtendService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.info.UserInformationService;
import com.bxm.egg.user.integration.LocationIntegrationService;
import com.bxm.egg.user.location.UserLocationService;
import com.bxm.egg.user.location.event.UserLocationChangeEvent;
import com.bxm.egg.user.mapper.UserAccountMapper;
import com.bxm.egg.user.mapper.UserInformationMapper;
import com.bxm.egg.user.mapper.UserLocationMapper;
import com.bxm.egg.user.mapper.UserStatisticsMapper;
import com.bxm.egg.user.model.entity.*;
import com.bxm.egg.user.properties.CommonProperties;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.egg.user.utils.FileMd5Util;
import com.bxm.newidea.component.oss.config.AliyunOssProperties;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;

import static com.bxm.newidea.component.tools.DateUtils.PATTERN_NO_DELIMITER_FORMAT;

/**
 * 用户扩展服务类
 *
 * @author wzy
 * @date 2021年09月14日17:08:21
 **/
@Service
@Slf4j
@AllArgsConstructor
public class UserExtendServiceImpl implements UserExtendService {

    private AliyunOSSService aliyunOSSService;

    private UserProperties userProperties;

    private CommonProperties commonProperties;

    private AliyunOssProperties aliyunOssProperties;

    private SequenceCreater sequenceCreater;

    private UserInformationMapper userInformationMapper;

    private UserStatisticsMapper userStatisticsMapper;

    private UserLocationMapper userLocationMapper;

    private UserAccountMapper userAccountMapper;

    private LocationIntegrationService locationIntegrationService;

    private UserPersonalInfoService userPersonalInfoService;

    private UserInformationService userInformationService;

    private UserLocationService userLocationService;

    private UserInfoService userInfoService;

    @Override
    @SuppressWarnings("all")
    public String uploadWechatImage(String headImg, Long userId) {
        if (StringUtils.isBlank(headImg)) {
            headImg = userProperties.getDefaultHeadImageUrl();
            return headImg;
        }
        if (headImg.startsWith(aliyunOssProperties.getCdnUrl())) {
            return headImg;
        }
        if (!StringUtils.startsWithAny(headImg, "http://", "https://")) {
            return userProperties.getDefaultHeadImageUrl();
        }

        try {
            //尝试获取高清图片地址,0代表高清头像，132代表132像素
            if (StringUtils.endsWith(headImg, "132")) {
                headImg = headImg.substring(0, headImg.length() - 3) + "0";
            } else if (StringUtils.endsWith(headImg, "96")
                    || StringUtils.endsWith(headImg, "64")
                    || StringUtils.endsWith(headImg, "46")) {
                headImg = headImg.substring(0, headImg.length() - 2) + "0";
            }

            URL url = new URL(headImg);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();

            // 设置连接超时时间
            conn.setConnectTimeout(3000);
            InputStream inputStream = null;

            // 正常响应时获取输入流, 在这里也就是图片对应的字节流
            if (conn.getResponseCode() == HttpStatus.OK.value()) {
                inputStream = conn.getInputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                int n = 0;
                while ((n = inputStream.read(buf)) >= 0) {
                    baos.write(buf, 0, n);
                }
                byte[] content = baos.toByteArray();
                String md5 = FileMd5Util.getMd5(content);
                if (commonProperties.getEmptyHeadImgFileMd5().contains(md5)) {
                    return userProperties.getDefaultHeadImageUrl();
                }
                inputStream = new ByteArrayInputStream(content);
                log.debug("根据url获得图片的流状态：{}", inputStream.available());
            }
            //不知道用户id---随机生成一个id来存到对应图片路径中
            if (userId == null) {
                userId = SequenceHolder.nextLongId();
            }

            int hashCode = (int) (userId % 100);
            String path = "egg/";
            String datePath = PATTERN_NO_DELIMITER_FORMAT.get().format(new Date());
            path += "avatar/" + datePath + hashCode + "/" + Long.toHexString(userId) + ".jpeg";

            return aliyunOSSService.upload(inputStream, path) + "?x-oss-process=style/head";
        } catch (IOException e) {
            log.error("微信授权上传头像出错，使用默认头像，用户id:[{}],用户头像:[{}],错误:[{}]", userId, headImg, e.getMessage());
            headImg = userProperties.getDefaultHeadImageUrl();
        }

        return headImg;
    }

    @Override
    @Async
    public void initUserExtendData(UserInfoEntity newUser) {
        //初始化用户资料数据
        UserInformationEntity newUserInformation = new UserInformationEntity();

        newUserInformation.setId(sequenceCreater.nextLongId());
        newUserInformation.setUserId(newUser.getId());

        userInformationMapper.insert(newUserInformation);

        //初始化用户统计数据
        UserStatisticsEntity newUserStatisticsEntity = new UserStatisticsEntity();

        newUserStatisticsEntity.setId(sequenceCreater.nextLongId());
        newUserStatisticsEntity.setUserId(newUser.getId());

        userStatisticsMapper.insert(newUserStatisticsEntity);

        //初始化定位数据
        UserLocationEntity newUserLocationEntity = new UserLocationEntity();
        newUserLocationEntity.setId(sequenceCreater.nextLongId());
        newUserLocationEntity.setUserId(newUser.getId());
        LocationDTO defaultLocationDTO = locationIntegrationService.getLocationByGeocode(userProperties.getDefaultLocationCode());
        if (defaultLocationDTO != null) {
            newUserLocationEntity.setLocationCode(userProperties.getDefaultLocationCode());
            newUserLocationEntity.setLocationName(defaultLocationDTO.getName());

            //更新用户地理位置以及其他操作
            SpringContextHolder.getApplicationContext().publishEvent(UserLocationChangeEvent.builder()
                    .areaCode(userProperties.getDefaultLocationCode())
                    .areaName(defaultLocationDTO.getName())
                    .userId(newUser.getId())
                    .build());
        }

        userLocationMapper.insert(newUserLocationEntity);

        //初始化账户数据
        UserAccountEntity newUserAccountEntity = new UserAccountEntity();

        newUserAccountEntity.setId(sequenceCreater.nextLongId());
        newUserAccountEntity.setUserId(newUser.getId());

        userAccountMapper.insert(newUserAccountEntity);

        //初始化资料完成度
        doInitComplete(newUser,
                newUserInformation,
                newUserLocationEntity);

    }


    @Override
    @Async
    public void initComplete(Long userId) {
        UserInfoEntity userInfoEntity = userInfoService.selectUserById(userId);

        UserInformationEntity userInformationEntity = userInformationService.getUserInformationByUserId(userId);

        UserLocationEntity userLocationEntity = userLocationService.getUserLocationByUserId(userId);

        doInitComplete(userInfoEntity, userInformationEntity, userLocationEntity);

    }


    /**
     * 初始化资料完成度
     *
     * @param userInfo        用户信息
     * @param userInformation 资料信息
     * @param userLocation    用户定位信息
     */
    private void doInitComplete(UserInfoEntity userInfo,
                                UserInformationEntity userInformation,
                                UserLocationEntity userLocation) {

        Long initUserInfoCompleteStatus = userPersonalInfoService.initUserInfoCompleteStatus(userInfo,
                userInformation, userLocation);

        if (log.isDebugEnabled()) {
            log.debug("用户id:{}, 初始化资料完成度: {}", userInfo.getId(), initUserInfoCompleteStatus);
        }

        UserInformationEntity updateUserInformation = new UserInformationEntity();

        updateUserInformation.setInfoCompleteState(initUserInfoCompleteStatus);
        LambdaQueryWrapper<UserInformationEntity> queryWrapper =
                new LambdaQueryWrapper<>();

        queryWrapper.eq(UserInformationEntity::getUserId, userInfo.getId());

        userInformationMapper.update(updateUserInformation, queryWrapper);

    }
}
