package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.constant.UserStateEnum;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.integration.sync.HuolaUserRegisterIntegrationService;
import com.bxm.egg.user.mapper.UserGrantWechatAppMapper;
import com.bxm.egg.user.mapper.UserInfoMapper;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.login.canel.CancelUserParam;
import com.bxm.egg.user.properties.CommonProperties;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.egg.user.utils.FileMd5Util;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.sync.facade.dto.UserRegisterDTO;
import com.bxm.sync.facade.param.UserRegisterParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/14 2:09 下午
 */
@Slf4j
@Service
public class UserInfoServiceImpl implements UserInfoService {
    @Resource
    private UserInfoMapper userInfoMapper;

    @Autowired
    private UserInfoCacheService userInfoCacheService;

    @Resource
    private UserGrantWechatAppMapper userGrantWechatAppMapper;

    @Resource
    private HuolaUserRegisterIntegrationService userRegisterIntegrationService;

    @Autowired
    private CommonProperties commonProperties;

    @Autowired
    private UserProperties userProperties;

    @Override
    public Boolean cancelUser(CancelUserParam cancelUserParam) {
        return null;
    }

    @Override
    public UserRegisterDTO generateUserId(UserRegisterParam userRegisterParam) {
        return userRegisterIntegrationService.userRegister(userRegisterParam);
    }

    @Override
    public void updateStatus(Long userId, UserStateEnum status) {

    }

    @Override
    public Optional<Long> userUnionIdExist(String unionId) {
        //判断用户是否存在
        LambdaQueryWrapper<UserGrantWechatAppEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserGrantWechatAppEntity::getUnionId, unionId);
        queryWrapper.eq(UserGrantWechatAppEntity::getDeleted, 0);

        List<UserGrantWechatAppEntity> userGrantWechatAppEntityList = userGrantWechatAppMapper.selectList(queryWrapper);

        if (!CollectionUtils.isEmpty(userGrantWechatAppEntityList)) {
            return Optional.ofNullable(userGrantWechatAppEntityList.get(0).getUserId());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> userPhoneExist(String phone) {
        //判断用户是否存在
        LambdaQueryWrapper<UserInfoEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserInfoEntity::getPhone, phone);

        List<UserInfoEntity> userInfoList = userInfoMapper.selectList(queryWrapper);

        if (!CollectionUtils.isEmpty(userInfoList)) {
            return Optional.of(userInfoList.get(0).getId());
        }

        return Optional.empty();
    }

    @Override
    public Optional<Long> userUsernameExist(String username) {
        Long userId = userInfoMapper.selectByUserName(username);

        if (null != userId) {
            return Optional.of(userId);
        }

        return Optional.empty();
    }

    @Override
    public boolean checkUserPassword(Long userId, String username, String password) {
        UserInfoEntity userInfoEntity = userInfoMapper.selectById(userId);

        String targetPassword = MD5Util.standardMd5(MD5Util.standardMd5(password) + userInfoEntity.getSalt());
        String realPassword = userInfoEntity.getPassword();

        return Objects.equals(targetPassword, realPassword);
    }

    @Override
    public void updateUserPassword(Long userId, String password) {
        UserInfoEntity dbUserInfo = userInfoMapper.selectById(userId);

        String salt = dbUserInfo.getSalt();
        UserInfoEntity userInfoEntity = new UserInfoEntity();

        userInfoEntity.setId(userId);
        userInfoEntity.setPassword(MD5Util.standardMd5(MD5Util.standardMd5(password) + salt));

        userInfoMapper.updateById(userInfoEntity);
    }

    @Override
    public boolean hasSettingPassword(String username) {
        //判断用户是否存在
        LambdaQueryWrapper<UserInfoEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserInfoEntity::getUsername, username);

        List<UserInfoEntity> userInfoEntityList = userInfoMapper.selectList(queryWrapper);

        if (!CollectionUtils.isEmpty(userInfoEntityList)) {
            return StringUtils.isNotBlank(userInfoEntityList.get(0).getPassword());
        }
        log.error("用户名不存在，用户名：{}", username);

        return false;
    }

    @Override
    public void bindPhone(Long userId, String phone) {

        UserInfoEntity userInfoEntity = new UserInfoEntity();

        userInfoEntity.setId(userId);
        userInfoEntity.setPhone(phone);

        userInfoMapper.updateById(userInfoEntity);
    }

    @Override
    public void bindUsername(Long userId, String username) {
        UserInfoEntity userInfoEntity = new UserInfoEntity();

        userInfoEntity.setId(userId);
        userInfoEntity.setUsername(username);

        userInfoMapper.updateById(userInfoEntity);
    }

    @Override
    public UserInfoEntity selectUserById(Long userId) {
        LambdaQueryWrapper<UserInfoEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserInfoEntity::getId, userId);
        queryWrapper.eq(UserInfoEntity::getDeleted, 0);
        return userInfoMapper.selectOne(queryWrapper);
    }

    @Override
    public UserInfoEntity selectAllUserById(Long userId) {
        LambdaQueryWrapper<UserInfoEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserInfoEntity::getId, userId);
        return userInfoMapper.selectOne(queryWrapper);
    }

    @Override
    public int updateUserInfo(UserInfoEntity userInfoEntity) {
        return userInfoMapper.updateById(userInfoEntity);
    }


    @Override
    public Boolean headImgRepair() {
        LambdaQueryWrapper<UserInfoEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserInfoEntity::getDeleted, 0);
        queryWrapper.eq(UserInfoEntity::getMigration, 1);
        List<UserInfoEntity> userInfoEntities = userInfoMapper.selectList(queryWrapper);

        userInfoEntities.forEach(userInfoEntity -> {
            if (updateHeadImg(userInfoEntity.getHeadImg())) {
                UserInfoEntity newUserInfo = new UserInfoEntity();
                newUserInfo.setId(userInfoEntity.getId());
                newUserInfo.setHeadImg(userProperties.getDefaultHeadImageUrl());
                userInfoMapper.updateById(newUserInfo);
                userInfoCacheService.clearUserCache(userInfoEntity.getId());
            }
        });

        return Boolean.TRUE;
    }

    private Boolean updateHeadImg(String headImg) {
        try {
            URL url = new URL(headImg);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();

            // 设置连接超时时间
            conn.setConnectTimeout(3000);
            InputStream inputStream = null;

            // 正常响应时获取输入流, 在这里也就是图片对应的字节流
            if (conn.getResponseCode() == HttpStatus.OK.value()) {
                inputStream = conn.getInputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                int n = 0;
                while ((n = inputStream.read(buf)) >= 0) {
                    baos.write(buf, 0, n);
                }
                byte[] content = baos.toByteArray();
                String md5 = FileMd5Util.getMd5(content);
                if (commonProperties.getEmptyHeadImgFileMd5().contains(md5)) {
                    return true;
                }
            }
        } catch (IOException e) {
            log.error("检验文件md5出错", e);
        }
        return false;
    }

}