package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.info.UserInformationService;
import com.bxm.egg.user.mapper.UserInformationMapper;
import com.bxm.egg.user.model.entity.UserInformationEntity;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/17 11:01 上午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserInformationServiceImpl implements UserInformationService {

    private final UserInformationMapper userInformationMapper;

    /**
     * 获取用户资料通过用户id
     *
     * @param userId 用户id
     * @return 用户资料信息
     */
    @Override
    public UserInformationEntity getUserInformationByUserId(Long userId) {
        //查询资料信息
        LambdaQueryWrapper<UserInformationEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(UserInformationEntity::getUserId, userId);

        UserInformationEntity userInformationEntity = userInformationMapper.selectOne(queryWrapper);

        if (userInformationEntity == null) {
            return buildDefaultInvalidInformation(userId);
        }

        return userInformationEntity;
    }

    private UserInformationEntity buildDefaultInvalidInformation(Long userId) {
        UserInformationEntity userInformationEntity = new UserInformationEntity();
        userInformationEntity.setId(0L);
        userInformationEntity.setUserId(userId);
        userInformationEntity.setJobTitle("");
        userInformationEntity.setPersonalProfile("这个人很懒，什么也没留下~");
        userInformationEntity.setInfoCompleteState(0L);
        userInformationEntity.setCreateTime(LocalDateTime.now());
        userInformationEntity.setModifyTime(LocalDateTime.now());

        return userInformationEntity;
    }


    /**
     * 更新用户的生日
     *
     * @param userId   用户id
     * @param birthday 生日
     * @return 影响行数
     */
    @Override
    public int updateUserBirthday(Long userId, Date birthday) {
        UserInformationEntity updateUserInformationEntity = new UserInformationEntity();

        updateUserInformationEntity.setUserId(userId);
        updateUserInformationEntity.setBirthday(birthday);

        LambdaQueryWrapper<UserInformationEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(UserInformationEntity::getUserId, userId);

        return userInformationMapper.update(updateUserInformationEntity, queryWrapper);
    }

    @Override
    public int updateBackgroundImgUrlByUserId(Long userId, String backgroundImgUrl) {

        LambdaQueryWrapper<UserInformationEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserInformationEntity::getUserId, userId);

        UserInformationEntity updateUserInformationEntity = new UserInformationEntity();
        updateUserInformationEntity.setUserId(userId);
        updateUserInformationEntity.setBackgroundImgUrl(backgroundImgUrl);

        return userInformationMapper.update(updateUserInformationEntity, queryWrapper);
    }

}