package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.user.constant.BaseDistributeKeyConstant;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.constant.UserBizConfigProperties;
import com.bxm.egg.user.convert.EggSixParamConverter;
import com.bxm.egg.user.enums.TempInviteSourceTypeEnum;
import com.bxm.egg.user.info.*;
import com.bxm.egg.user.info.msg.UserInfoChangeSender;
import com.bxm.egg.user.integration.EggSixEnjoyIntegrationService;
import com.bxm.egg.user.integration.MessageFacadeIntegrationService;
import com.bxm.egg.user.integration.SixEnjoyUserIntegrationService;
import com.bxm.egg.user.integration.farm.ChickenGroupIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyFriendsIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyUserAccountIntegrationService;
import com.bxm.egg.user.invite.egg.UserEggInviteService;
import com.bxm.egg.user.mapper.UserGrantWechatAppMapper;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.bo.UserInviteBO;
import com.bxm.egg.user.model.bo.UserWechatBindBO;
import com.bxm.egg.user.model.dto.info.UserBindWxDTO;
import com.bxm.egg.user.model.dto.info.UserBriefInfoDTO;
import com.bxm.egg.user.model.entity.EggInviteEntity;
import com.bxm.egg.user.model.entity.TempInviteBindEntity;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.param.UserBindWxParam;
import com.bxm.egg.user.properties.SixEnjoyUrlProperties;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.sync.facade.dto.UserRewardDTO;
import com.bxm.sync.facade.param.UpdateUserRewardParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/8 5:50 下午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserWechatGrantServiceImpl implements UserWechatGrantService {

    private final UserGrantWechatAppMapper userGrantWechatAppMapper;

    private final DistributedLock distributedLock;

    private final UserInfoService userInfoService;

    private final UserInfoCacheService userInfoCacheService;

    private final UserBaseInfoService userBaseInfoService;

    private final UserInfoChangeSender userInfoChangeSender;

    private final UserExtendService userExtendService;

    private final EggSixEnjoyIntegrationService eggSixEnjoyIntegrationService;

    private final SixEnjoyUserAccountIntegrationService enjoyUserAccountIntegrationService;

    private final SixEnjoyUserIntegrationService enjoyUserIntegrationService;

    private final UserEggInviteService userEggInviteService;

    private final UserBizConfigProperties userBizConfigProperties;

    private final MessageFacadeIntegrationService messageFacadeIntegrationService;

    private final SixEnjoyUrlProperties sixEnjoyUrlProperties;

    private final RedisSetAdapter redisSetAdapter;

    private final SixEnjoyFriendsIntegrationService sixEnjoyFriendsIntegrationService;

    private final ChickenGroupIntegrationService chickenGroupIntegrationService;

    private final SequenceCreater sequenceCreater;

    @Override
    public Optional<UserGrantWechatAppEntity> userInfoUnionIdExist(String unionId) {
        LambdaQueryWrapper<UserGrantWechatAppEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserGrantWechatAppEntity::getUnionId, unionId);
        queryWrapper.eq(UserGrantWechatAppEntity::getDeleted, 0);

        UserGrantWechatAppEntity userGrantWechatAppEntity = userGrantWechatAppMapper.selectOne(queryWrapper);

        if (Objects.nonNull(userGrantWechatAppEntity)) {
            return Optional.of(userGrantWechatAppEntity);
        }

        return Optional.empty();
    }

    @Override
    public int updateWechatGrantBindUserId(Long userId, String unionId) {
        LambdaQueryWrapper<UserGrantWechatAppEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserGrantWechatAppEntity::getUnionId, unionId);

        UserGrantWechatAppEntity updateEntity = new UserGrantWechatAppEntity();

        updateEntity.setUserId(userId);

        return userGrantWechatAppMapper.update(updateEntity, queryWrapper);

    }

    @Override
    public Message userBindWx(UserBindWxParam userBindWxParam) {

        String resource = buildBindWxUserLockKey(userBindWxParam.getUserId());

        if (!distributedLock.lock(resource)) {
            log.info("出现重复点击，请求参数：{}", JSON.toJSONString(userBindWxParam));
            return null;
        }

        //判断用户是否已经绑定微信
        if (userHasBindWx(userBindWxParam.getUserId())) {
            distributedLock.unlock(resource);
            return Message.build(false, "该用户已经绑定过微信，请勿重复绑定");
        }

        //如果已经存在绑定记录了则更新用户id
        if (this.userInfoUnionIdExist(userBindWxParam.getUnionId()).isPresent()) {
            //更新授权绑定信息
            updateWechatGrantBindUserId(userBindWxParam.getUserId(),
                    userBindWxParam.getUnionId());
        } else {
            UserWechatBindBO userWechatBindBO = new UserWechatBindBO();
            BeanUtils.copyProperties(userBindWxParam, userWechatBindBO);

            //添加微信授权记录
            grantBindWxRecord(userWechatBindBO);
        }

        //微信授权后更新用户头像等信息
        updateUserWxBindRelationInfo(userBindWxParam);

        //清空用户信息缓存
        userInfoChangeSender.sendUserChangeMsg(userBindWxParam.getUserId());

        //初始化资料完成度
        userExtendService.initComplete(userBindWxParam.getUserId());

        if (StringUtils.isGrateOrEqualThan(userBindWxParam.getCurVer(), "2.0.1")) {
            userBindWxHandler(userBindWxParam);
        } else {
            //调用六享微信绑定奖励
            eggSixEnjoyIntegrationService.bind(EggSixParamConverter.convert(userBindWxParam));
        }

        distributedLock.unlock(resource);
        return Message.build(true);
    }

    /**
     * 用户绑定微信后续操作
     *
     * @param userBindWxParam 用户绑定信息
     */
    @Override
    public void userBindWxHandler(UserBindWxParam userBindWxParam) {

        if (userBindWxParam.getPhone() == null) {
            UserCacheInfoBO load = userInfoCacheService.load(userBindWxParam.getUserId());
            userBindWxParam.setPhone(load.getPhone());
        }
        UserRewardDTO userRewardInfo = enjoyUserIntegrationService.getUserRewardInfo(userBindWxParam.getUserId(),
                userBindWxParam.getPhone(),
                userBindWxParam.getDevcId());

        if (userRewardInfo == null) {
            log.error("获取用户信息失败，请检验用户在六享是否存在：{}", userBindWxParam.getUserId());
            return;
        }
        KeyGenerator keyGenerator = userBindRewardKey(userBindWxParam.getUserId());
        Boolean exists = redisSetAdapter.exists(keyGenerator, userBindWxParam.getUserId());
        if (exists) {
            log.debug("用户已发放过奖励：{}", userBindWxParam.getUserId());
            return;
        }

        //发送用户奖励
        UserInviteBO userInviteBO = sendUserReward(userRewardInfo, userBindWxParam);

        newSendInviteUserReward(userRewardInfo, userBindWxParam, userInviteBO);

        redisSetAdapter.add(keyGenerator, userBindWxParam.getUserId());
    }


    private KeyGenerator userBindRewardKey(Long userId) {
        return RedisConfig.USER_BIND_WX_REWARD.copy().appendKey(userId % 100);
    }

    private void newSendInviteUserReward(UserRewardDTO userRewardInfo, UserBindWxParam userBindWxParam, UserInviteBO userInviteBO) {
        //用户邀请信息不存在
        if (userInviteBO.getInviteUserInfo() == null) {
            return;
        }

        inviteRewardUpdate(userRewardInfo, userBindWxParam, userInviteBO);
    }

    private void inviteRewardUpdate(UserRewardDTO userRewardInfo, UserBindWxParam userBindWxParam, UserInviteBO userInviteBO) {
        UserBriefInfoDTO inviteUserInfo = userInviteBO.getInviteUserInfo();

        //建立好友关系
        sixEnjoyFriendsIntegrationService.insertFriendsToSixEnjoy(userBindWxParam.getUserId(), inviteUserInfo.getUserId());
        //更新邀请人关系，更新了六享数据则会触发canal同步邀请关系，火啦不用增加邀请关系
        Boolean updateUserInvite = enjoyUserIntegrationService.updateUserInvite(userBindWxParam.getUserId(), inviteUserInfo.getUserId());
        //如果更新没成功，且邀请信息本来就存在数据库中，则说明是老板APP用户邀请的，用了新版绑定微信
        if (!updateUserInvite && Objects.equals(null, userRewardInfo.getIsTempInvite())) {
            log.error("给六享绑定邀请关系失败，请检查dubbo问题还是用户已有绑定人：userId:{},inviteUserInfo:{}", userBindWxParam.getUserId(), JSON.toJSONString(inviteUserInfo));
            return;
        }

        //老版APP用户邀请的，用了新版绑定微信，补偿邀请信息
        if (Objects.equals(Boolean.FALSE, userRewardInfo.getIsTempInvite())) {
            EggInviteEntity eggInviteEntity = new EggInviteEntity();
            eggInviteEntity.setId(sequenceCreater.nextLongId());
            eggInviteEntity.setUserId(inviteUserInfo.getUserId());
            eggInviteEntity.setBeInviteUserId(userBindWxParam.getUserId());
            eggInviteEntity.setCreateTime(new Date());
            eggInviteEntity.setBeInviteRegTime(new Date());
            userEggInviteService.insertInviteInfo(eggInviteEntity);
        }
        //更新邀请人关系成功，则发送邀请奖励
        sendInviteUserReward(inviteUserInfo.getUserId(), userBindWxParam.getNickName(), userInviteBO.getSendInviteUserReward());
    }


    private void sendInviteUserReward(Long inviteUserId, String beInviteUserName, int sendInviteUserReward) {
        if (sendInviteUserReward > 0) {
            //发送奖励
            enjoyUserAccountIntegrationService.addFoodsNum(inviteUserId,
                    sendInviteUserReward, "邀请新用户[" + beInviteUserName + "]");

            PushMessage message = PushMessage.build("邀请好友奖励已送达",
                    "您邀请的好友[" + beInviteUserName + "]已注册并绑定微信，奖励您"
                            + sendInviteUserReward + "g粮食，多邀多得哦~");
            message.assign(inviteUserId);
            message.getPayloadInfo().setProtocol(ProtocolFactory.appH5()
                    .url(sixEnjoyUrlProperties.getInvitePage())
                    .build());

            messageFacadeIntegrationService.sendPushMessage(message);
        }
    }


    private UserInviteBO sendUserReward(UserRewardDTO userRewardInfo, UserBindWxParam userBindWxParam) {
        int sendInviteUserReward = 0;
        UserInviteBO userInviteBO = UserInviteBO.builder().build();
        //填充邀请关系
        userInviteBO.setInviteUserInfo(fillInviteUserInfo(userRewardInfo, userBindWxParam));

        log.info("用户当前奖励信息：userRewardInfo：{}，邀请人信息：{}", JSON.toJSONString(userRewardInfo), JSON.toJSONString(userInviteBO));

        UserBriefInfoDTO inviteUserInfo = userInviteBO.getInviteUserInfo();
        String inviteName = null;
        if (Objects.nonNull(inviteUserInfo)) {
            inviteName = inviteUserInfo.getNickname();
        }
        UpdateUserRewardParam updateUserRewardParam = new UpdateUserRewardParam();

        if (!userRewardInfo.getRegisterReward()) {
            //发送奖励
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("新用户注册奖励");
            if (inviteName != null) {
                stringBuilder.append("（邀请人:").append(inviteName).append("）");
            }
            enjoyUserAccountIntegrationService.addFoodsNum(userBindWxParam.getUserId(),
                    userBizConfigProperties.getRegisterReward(), stringBuilder.toString());
            sendInviteUserReward += userBizConfigProperties.getInviteReward();

            updateUserRewardParam.setRegisterReward(true);
            updateUserRewardParam.setDevcId(userBindWxParam.getDevcId());
        }
        if (!userRewardInfo.getWxReward()) {
            //发送奖励
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("新用户微信绑定奖励");
            if (inviteName != null) {
                stringBuilder.append("（邀请人:").append(inviteName).append("）");
            }
            enjoyUserAccountIntegrationService.addFoodsNum(userBindWxParam.getUserId(),
                    userBizConfigProperties.getWxBindReward(), stringBuilder.toString());
            sendInviteUserReward += userBizConfigProperties.getInviteReward();

            updateUserRewardParam.setWxReward(true);
        }

        //更新信息
        updateUserRewardParam.setUserId(userBindWxParam.getUserId());
        updateUserRewardParam.setNickname(userBindWxParam.getNickName());
        updateUserRewardParam.setHeadImg(userBindWxParam.getHeadImageUrl());
        enjoyUserIntegrationService.updateUserReward(updateUserRewardParam);


        userInviteBO.setSendInviteUserReward(sendInviteUserReward);

        return userInviteBO;
    }

    private UserBriefInfoDTO fillInviteUserInfo(UserRewardDTO userRewardInfo, UserBindWxParam userBindWxParam) {

        //如果用户存在邀请人，且不是临时关系的类型，则不用走火啦临时邀请关系
        if (Objects.nonNull(userRewardInfo.getInviteUserId()) && Objects.equals(userRewardInfo.getIsTempInvite(), Boolean.FALSE)) {
            return userBaseInfoService.getSingleUserBriefInfo(userRewardInfo.getInviteUserId());
        }

        //六享邀请人是临时邀请,或者不存在邀请关系，走查看火啦的邀请关系
        if (Objects.equals(userRewardInfo.getIsTempInvite(), Boolean.TRUE) || userRewardInfo.getIsTempInvite() == null) {
            //先走火啦的临时邀请
            TempInviteBindEntity userTempBindInvite = userEggInviteService.getUserTempBindInvite(userBindWxParam.getUnionId());

            if (Objects.nonNull(userTempBindInvite)) {
                //加入合养
                inviteJoinGroup(userTempBindInvite, userBindWxParam.getUserId());
                //如果火啦临时邀请关系存在，则使用火啦临时邀请关系
                UserInfoEntity userInfoEntity = userInfoService.selectAllUserById(userBindWxParam.getUserId());
                //如果用户创建时间大于  临时邀请时间，则查询火啦邀请人信息
                if (userInfoEntity.getCreateTime().getTime() >= userTempBindInvite.getCreateTime().getTime()) {
                    return userBaseInfoService.getSingleUserBriefInfo(userTempBindInvite.getUserId());
                }
            }

            //火啦不存在，则才走六享
            if (Objects.nonNull(userRewardInfo.getInviteUserId())) {
                return userBaseInfoService.getSingleUserBriefInfo(userRewardInfo.getInviteUserId());
            }
        }
        return null;
    }


    private void inviteJoinGroup(TempInviteBindEntity userTempBindInvite, Long userId) {
        //如果来源为合养页，则添加合养信息
        if (Objects.equals(TempInviteSourceTypeEnum.CHICKEN_GROUP_PAGE.getType(), userTempBindInvite.getSource())) {
            chickenGroupIntegrationService.inviteJoinGroup(userId, userTempBindInvite.getUserId());
        }
    }

    /**
     * 微信授权后更新用户头像等信息
     *
     * @param userBindWxParam 微信绑定入参
     */
    private void updateUserWxBindRelationInfo(UserBindWxParam userBindWxParam) {
        UserInfoEntity updateUserInfo = new UserInfoEntity();

        String newHeadImg = userExtendService.uploadWechatImage(userBindWxParam.getHeadImageUrl(),
                userBindWxParam.getUserId());

        userBindWxParam.setHeadImageUrl(newHeadImg);
        updateUserInfo.setId(userBindWxParam.getUserId());
        updateUserInfo.setHeadImg(newHeadImg);
        updateUserInfo.setNickname(userBindWxParam.getNickName());
        updateUserInfo.setSex(userBindWxParam.getSex());

        userInfoService.updateUserInfo(updateUserInfo);
    }

    /**
     * 判断用户是否已经绑定微信
     *
     * @param userId 用户id
     * @return 是否绑定
     */
    @Override
    public Boolean userHasBindWx(Long userId) {
        LambdaQueryWrapper<UserGrantWechatAppEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserGrantWechatAppEntity::getUserId, userId);
        queryWrapper.eq(UserGrantWechatAppEntity::getDeleted, 0);

        List<UserGrantWechatAppEntity> grantWechatAppEntityList = userGrantWechatAppMapper.selectList(queryWrapper);

        return !CollectionUtils.isEmpty(grantWechatAppEntityList);
    }

    @Override
    public Boolean grantBindWxRecord(UserWechatBindBO userWechatBindBO) {
        // 保留微信授权信息
        UserGrantWechatAppEntity entity = new UserGrantWechatAppEntity();
        entity.setId(SequenceHolder.nextLongId());

        entity.setCountry(userWechatBindBO.getCountry());
        entity.setProvince(userWechatBindBO.getProvince());
        entity.setCity(userWechatBindBO.getCity());
        entity.setNickName(userWechatBindBO.getNickName());
        entity.setHeadImg(userWechatBindBO.getHeadImageUrl());
        entity.setOpenId(userWechatBindBO.getOpenId());
        entity.setUnionId(userWechatBindBO.getUnionId());
        entity.setSex(userWechatBindBO.getSex());

        entity.setUserId(userWechatBindBO.getUserId());
        entity.setCreateTime(new Date());

        return userGrantWechatAppMapper.insert(entity) > 0;
    }

    /**
     * 构建用户绑定微信分布式锁，保证不重复请求
     *
     * @param userId 用户id
     * @return 分布式锁key
     */
    private String buildBindWxUserLockKey(Long userId) {
        return BaseDistributeKeyConstant.USER_BIND_WX_LOCK_KEY.copy().appendKey(userId).gen();
    }

    @Override
    public UserBindWxDTO getUserHasBindWx(Long userId, Long devcId) {
        UserRewardDTO userRewardInfo = enjoyUserIntegrationService.getUserRewardInfo(userId, null, devcId);
        Boolean userHasBindWx = userHasBindWx(userId);

        if (userHasBindWx) {
            return UserBindWxDTO.builder()
                    .isBind(userHasBindWx)
                    .build();
        }

        return UserBindWxDTO.builder()
                .foodsNum(userRewardInfo != null && userRewardInfo.getRegisterReward() ?
                        userBizConfigProperties.getWxBindReward() : userBizConfigProperties.getRegisterWxAndReward())
                .isBind(false)
                .build();
    }
}