package com.bxm.egg.user.invite;

import com.bxm.egg.user.model.param.InviteProcessParam;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;

/**
 * 邀请逻辑处理服务接口
 *
 * @author liujia
 * @date 2020/05/11 19:53
 */
public interface InviteProcessService {

    /**
     * 邀请关系生效的处理逻辑
     * 邀请生效后的逻辑与当前用户不需要太多关联，使用异步线程进行处理
     *
     * @param param 邀请逻辑处理参数
     */
    void execAsyncActiveInvite(InviteProcessParam param);

    /**
     * 获取邀请用户显示的最终标题
     *
     * @param history 邀请用户的记录
     * @return 显示标题
     */
    String getFinalInviteTitle(UserInviteHistoryBean history);

    /**
     * 判断师徒等级，然后根据师徒等级来显示不同的标题
     *
     * @param userId  : 需要比对的用户id，判断这个用户id 是不是直接邀请师傅[只有invite_user_id]才是直接邀请，其他都是间接
     * @param history : 邀请关系
     * @return ： 显示标题
     */
    String getLevelTwoFinalInviteTitle(Long userId, UserInviteHistoryBean history);
}
