package com.bxm.egg.user.invite.egg.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.mq.common.message.AddFriendMessage;
import com.bxm.egg.mq.common.message.RequestGrainMessage;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.dto.SixEnjoyReceiveFoodsDTO;
import com.bxm.egg.user.enums.TempInviteSourceTypeEnum;
import com.bxm.egg.user.enums.UserFollowStatusEnum;
import com.bxm.egg.user.follow.UserFollowService;
import com.bxm.egg.user.info.UserBaseInfoService;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.info.UserWechatGrantService;
import com.bxm.egg.user.integration.MessageFacadeIntegrationService;
import com.bxm.egg.user.integration.farm.ChickenGroupIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyFriendsIntegrationService;
import com.bxm.egg.user.integration.sync.SixEnjoyInviteFoodsIntegrationService;
import com.bxm.egg.user.invite.egg.UserEggInviteService;
import com.bxm.egg.user.mapper.EggInviteMapper;
import com.bxm.egg.user.mapper.TempInviteBindMapper;
import com.bxm.egg.user.model.bo.UserCacheInfoBO;
import com.bxm.egg.user.model.dto.invite.RollBarrageDTO;
import com.bxm.egg.user.model.dto.invite.egg.InviteUserListDTO;
import com.bxm.egg.user.model.entity.EggInviteEntity;
import com.bxm.egg.user.model.entity.TempInviteBindEntity;
import com.bxm.egg.user.model.entity.UserGrantWechatAppEntity;
import com.bxm.egg.user.model.param.invite.ApplyFriendParam;
import com.bxm.egg.user.model.param.invite.CheckBindParam;
import com.bxm.egg.user.model.param.invite.InviteBindParam;
import com.bxm.egg.user.model.param.invite.egg.InvitePageParam;
import com.bxm.egg.user.properties.SixEnjoyUrlProperties;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.dto.IPageModel;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.sync.facade.dto.UserTodayContributionDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

import static com.bxm.newidea.component.JSON.parseObject;
import static com.bxm.newidea.component.JSON.toJSONString;

/**
 * 蛋蛋佳用户邀请service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/24 5:19 下午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserEggInviteServiceImpl implements UserEggInviteService {

    private final EggInviteMapper eggInviteMapper;

    private final UserProperties userProperties;

    private final TempInviteBindMapper tempInviteBindMapper;

    private final SixEnjoyUrlProperties sixEnjoyUrlProperties;

    private final SixEnjoyInviteFoodsIntegrationService inviteFoodsIntegrationService;

    private final UserInfoCacheService userInfoCacheService;

    private final RedisStringAdapter redisStringAdapter;

    private final DistributedLock distributedLock;

    private final SequenceCreater sequenceCreater;

    private final SixEnjoyFriendsIntegrationService sixEnjoyFriendsIntegrationService;

    private final ChickenGroupIntegrationService chickenGroupIntegrationService;

    private final UserFollowService userFollowService;

    private final MessageFacadeIntegrationService messageFacadeIntegrationService;


    public UserWechatGrantService getUserWechatGrantService() {
        return SpringContextHolder.getBean(UserWechatGrantService.class);
    }

    @Override
    public IPageModel<InviteUserListDTO> inviteList(InvitePageParam invitePageParam) {
        Page<InviteUserListDTO> page = new Page<>(invitePageParam.getPageNum(), invitePageParam.getPageSize());
        page.setSearchCount(false);

        if (null == invitePageParam.getUserId()) {
            return PlusPageModelDTO.build(null);
        }
        List<UserTodayContributionDTO> userFoodsList = inviteFoodsIntegrationService.getTodayContribution(invitePageParam.getUserId());

        List<InviteUserListDTO> userListDTOS = userFoodsList.stream().map(todayContributionDTO -> {
            UserCacheInfoBO cacheInfoBO = userInfoCacheService.load(todayContributionDTO.getUserId());
            InviteUserListDTO inviteUser = new InviteUserListDTO();
            inviteUser.setHeadImg(cacheInfoBO.getHeadImg());
            inviteUser.setNickName(cacheInfoBO.getNickname());
            inviteUser.setContributeFoodsNum(todayContributionDTO.getFoodNum());
            inviteUser.setContributeAllFoodsNum(todayContributionDTO.getAllFoodNum());
            return inviteUser;
        }).collect(Collectors.toList());
        List<InviteUserListDTO> collect = userListDTOS.stream()
                .sorted(Comparator.comparing(InviteUserListDTO::getContributeFoodsNum).reversed()).collect(Collectors.toList());
        IPage<InviteUserListDTO> listDTOIPage = new Page<>();
        listDTOIPage.setRecords(collect);
        PlusPageModelDTO<InviteUserListDTO> pageModelDTO = PlusPageModelDTO.build(listDTOIPage);
        if (userFoodsList.size() == invitePageParam.getPageSize()) {
            pageModelDTO.setHasNextPage(true);
            pageModelDTO.setLastPage(false);
        } else {
            pageModelDTO.setHasNextPage(false);
            pageModelDTO.setLastPage(true);
        }

        return pageModelDTO;
    }

    @Override
    public Long getInviteUserId(Long userId) {
        LambdaQueryWrapper<EggInviteEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(EggInviteEntity::getBeInviteUserId, userId);
        EggInviteEntity eggInviteEntity = eggInviteMapper.selectOne(queryWrapper);

        if (eggInviteEntity != null) {
            return eggInviteEntity.getUserId();
        }
        return null;
    }

    @Override
    public int countInviteUser(Long userId) {
        LambdaQueryWrapper<EggInviteEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(EggInviteEntity::getUserId, userId);

        return eggInviteMapper.selectCount(queryWrapper);
    }

    @Override
    public List<String> getUserInviteHeadImgList(Long userId) {
        return eggInviteMapper.getInviteUserHeadImg(userId, userProperties.getInviteHeadImgNum());
    }

    @Override
    public List<RollBarrageDTO> getRollBarrage() {

        List<RollBarrageDTO> rollBarrageDTOS = redisStringAdapter.get(RedisConfig.INVITE_USER_ROLL_BARRAGE.copy(), new TypeReference<List<RollBarrageDTO>>() {
        });
        if (rollBarrageDTOS == null || rollBarrageDTOS.isEmpty()) {
            return Lists.newArrayList();
        }
        return rollBarrageDTOS;
    }

    @Override
    public Boolean tempBindInvite(InviteBindParam inviteBindParam) {

        boolean lock = distributedLock.lock(inviteBindParam.getUnionId() + inviteBindParam.getUserId());
        if (!lock) {
            log.info("出现重复点击，请求参数：{}", JSON.toJSONString(inviteBindParam));
            return Boolean.FALSE;
        }
        Optional<UserGrantWechatAppEntity> userGrantWechatAppEntity = getUserWechatGrantService().userInfoUnionIdExist(inviteBindParam.getUnionId());

        if (userGrantWechatAppEntity.isPresent()) {
            //如果被邀请人已注册APP，则只建立好友关系
            //如果来源为合养页，则添加合养信息
            if (Objects.equals(TempInviteSourceTypeEnum.CHICKEN_GROUP_PAGE.getType(), inviteBindParam.getSource())) {
                chickenGroupIntegrationService.inviteJoinGroup(userGrantWechatAppEntity.get().getUserId(), inviteBindParam.getUserId());
            }
            sixEnjoyFriendsIntegrationService.insertFriendsToSixEnjoy(inviteBindParam.getUserId(), userGrantWechatAppEntity.get().getUserId());
        } else {
            delInviteBindByUnionId(inviteBindParam.getUnionId());
            //建立新的邀请关系
            TempInviteBindEntity tempInviteBindEntity = new TempInviteBindEntity();
            tempInviteBindEntity.setId(sequenceCreater.nextLongId());
            tempInviteBindEntity.setUnionId(inviteBindParam.getUnionId());
            tempInviteBindEntity.setUserId(inviteBindParam.getUserId());
            tempInviteBindEntity.setSource(inviteBindParam.getSource());
            tempInviteBindEntity.setCreateTime(new Date());
            tempInviteBindMapper.insert(tempInviteBindEntity);
        }
        distributedLock.unlock(inviteBindParam.getUnionId() + inviteBindParam.getUserId());
        return Boolean.TRUE;
    }

    @Override
    public TempInviteBindEntity getUserTempBindInvite(String unionId) {
        LambdaQueryWrapper<TempInviteBindEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TempInviteBindEntity::getUnionId, unionId);
        return tempInviteBindMapper.selectOne(queryWrapper);
    }

    @Override
    public void delInviteBindByUnionId(String unionId) {
        //删除老的临时邀请关系，建立新的邀请关系
        tempInviteBindMapper.delInviteBindByUnionId(unionId);
    }

    @Override
    public void delInviteBindByDate(Date date) {
        //删除老的临时邀请关系，建立新的邀请关系
        tempInviteBindMapper.delInviteBindByDate(date);
    }

    @Override
    public Integer getReceiveContributeFoods(Long userId) {

        UserCacheInfoBO load = userInfoCacheService.load(userId);
        Map<String, String> param = new HashMap();
        param.put("bxm_mobile", load.getPhone());
        SixEnjoyReceiveFoodsDTO request = request(param, sixEnjoyUrlProperties.getCanReceiveFoodsUrl());
        return request != null && request.getCode() == 1 ? request.getData() : 0;
    }

    @Override
    public Boolean receiveFoods(Long userId) {
        boolean lock = distributedLock.lock(userId.toString());
        if (!lock) {
            log.info("出现重复领取粮食，请求参数：{}", userId);
            return Boolean.FALSE;
        }
        UserCacheInfoBO load = userInfoCacheService.load(userId);
        Map<String, String> param = new HashMap();
        param.put("bxm_mobile", load.getPhone());
        SixEnjoyReceiveFoodsDTO request = request(param, sixEnjoyUrlProperties.getReceiveFoodsUrl());
        distributedLock.unlock(userId.toString());
        return request != null && request.getCode() == 1;
    }


    private SixEnjoyReceiveFoodsDTO request(Map<String, String> param, String url) {
        String response = OkHttpUtils.postJsonBody(url, toJSONString(param), null);
        if (log.isDebugEnabled()) {
            log.debug("调用蛋蛋佳,请求数据：{},响应结果：{}",
                    toJSONString(param),
                    response);
        }
        return parseObject(response, SixEnjoyReceiveFoodsDTO.class);
    }

    public static void main(String[] args) {
        Map<String, String> param = new HashMap();
        param.put("bxm_mobile", "18363370745");
        String response = OkHttpUtils.postJsonBody("https://bxm.liuxiang.city/api/yangjixiadan/Xiaochengxu/yaoqing_lingqu_bxm", toJSONString(param), null);
        SixEnjoyReceiveFoodsDTO sixEnjoyReceiveFoodsDTO = parseObject(response, SixEnjoyReceiveFoodsDTO.class);
        System.out.println("response = " + sixEnjoyReceiveFoodsDTO);
    }

    @Override
    public void delInviteInfoByUserId(Long userId) {
        eggInviteMapper.delInviteInfoByUserId(userId);
    }

    @Override
    public EggInviteEntity getInviteUserIdByBeUser(Long beInviteUserId) {
        LambdaQueryWrapper<EggInviteEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(EggInviteEntity::getBeInviteUserId, beInviteUserId);

        return eggInviteMapper.selectOne(queryWrapper);
    }


    @Override
    public Message sendFriendApply(CheckBindParam param) {
        boolean lock = distributedLock.lock(param.getUserId() + param.getFarmUserId().toString());

        if (!lock) {
            log.info("出现重复点击发送好友请求，请求参数：{}", JSON.toJSONString(param));
            return Message.build(false).setMessage("出现重复点击发送好友请求");
        }
        KeyGenerator userFriendKey = RedisConfig.USER_FRIEND_APPLY.copy().appendKey(param.getUserId()).appendKey(param.getFarmUserId());
        Integer count = redisStringAdapter.get(userFriendKey, Integer.class);

        if (count != null && count > 0) {
            //当前好友申请次数是否超过一次
            distributedLock.unlock(param.getUserId() + param.getFarmUserId().toString());
            return Message.build(false).setMessage("您今日已发送申请,请等待对方同意");
        }

        UserBaseInfoService userBaseInfoService = SpringContextHolder.getBean(UserBaseInfoService.class);
        String nickName = userBaseInfoService.getSingleUserBriefInfo(param.getUserId()).getNickname();
        messageFacadeIntegrationService.sendAddFriendMessage(param.getUserId(), nickName, param.getFarmUserId());
        //将好友申请记录存放到redis
        redisStringAdapter.set(userFriendKey, 1);
        redisStringAdapter.expire(userFriendKey, 24 * 60 * 60);
        distributedLock.unlock(param.getUserId() + param.getFarmUserId().toString());
        return Message.build(true);
    }


    @Override
    public Message adoptFriendApply(ApplyFriendParam param) {
        boolean lock = distributedLock.lock(param.getUserId() + param.getApplyUserId().toString());
        if (!lock) {
            log.info("出现重复点击同意好友申请，请求参数：{}", JSON.toJSONString(param));
            return Message.build(false).setMessage("出现重复点击同意好友申请");
        }
        //当前用户和目标用户需要相互关注对方才能成为好友，所以需要交换位置 两次调用关注
        Boolean isUserFriend = userFollowService.addHuolaFriends(param.getUserId(), param.getApplyUserId(), UserFollowStatusEnum.FOLLOW.getCode());
        Boolean isFarmFriend = userFollowService.addHuolaFriends(param.getApplyUserId(), param.getUserId(), UserFollowStatusEnum.FOLLOW.getCode());

        if (isUserFriend || isFarmFriend) {
            UserBaseInfoService userBaseInfoService = SpringContextHolder.getBean(UserBaseInfoService.class);
            String nickName = userBaseInfoService.getSingleUserBriefInfo(param.getUserId()).getNickname();
            messageFacadeIntegrationService.adoptFriendMessage(param.getUserId(), nickName, param.getApplyUserId());
            return Message.build(true);
        }
        log.error("他人农场用户添加好友失败,参数:{}", JSON.toJSONString(param));
        distributedLock.unlock(param.getUserId() + param.getApplyUserId().toString());
        return Message.build(false).setMessage("添加好友失败");
    }


    @Override
    public Boolean checkIsFriend(CheckBindParam param) {

        return false;
    }

    @Override
    public void insertInviteInfo(EggInviteEntity eggInviteEntity) {
        eggInviteMapper.insertInviteInfo(eggInviteEntity);
    }
}