package com.bxm.egg.user.invite.impl;

import com.bxm.egg.user.enums.AppConst;
import com.bxm.egg.user.enums.InviteBindMethodEnum;
import com.bxm.egg.user.info.UserInfoCacheService;
import com.bxm.egg.user.invite.*;
import com.bxm.egg.user.invite.bind.BindInviteManager;
import com.bxm.egg.user.model.dto.UserInviteBindDTO;
import com.bxm.egg.user.model.param.InviteProcessParam;
import com.bxm.egg.user.model.vo.InviteRecord;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.SpringContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Service
@Slf4j
public class InviteProcessServiceImpl implements InviteProcessService {

    private final InviteTypeProcessorManager inviteTypeProcessorManager;

    private final InviteRecordService inviteRecordService;

    private UserInviteService userInviteService;

    private final BindInviteManager bindInviteManager;

    private final UserInfoCacheService userInfoCacheService;

    @Autowired
    public InviteProcessServiceImpl(InviteTypeProcessorManager inviteTypeProcessorManager,
                                    InviteRecordService inviteRecordService, BindInviteManager bindInviteManager, UserInfoCacheService userInfoCacheService) {
        this.inviteTypeProcessorManager = inviteTypeProcessorManager;
        this.inviteRecordService = inviteRecordService;
        this.bindInviteManager = bindInviteManager;
        this.userInfoCacheService = userInfoCacheService;
    }

    private UserInviteService getUserInviteService() {
        if (userInviteService == null) {
            userInviteService = SpringContextHolder.getBean(UserInviteService.class);
        }
        return userInviteService;
    }

    @Override
    @Async
    public void execAsyncActiveInvite(InviteProcessParam param) {
        log.debug("处理用户建立的邀请关系:{}", param);

        InviteRecord inviteRecord = inviteRecordService.getInviteRecordByInvitedUser(param.getInviteUserId(),
                param.getUserId());

        if (null != inviteRecord) {
            InviteProcessorContext context = new InviteProcessorContext();
            context.setRecord(inviteRecord);
            context.setBasicParam(param.getBasicParam());
            context.setInvitedEquipment(param.getEquipmentNum());
            context.setEffective(param.isEffective());
            context.setLoginIp(param.getLoginIp());

            Message message = inviteTypeProcessorManager.obtain(inviteRecord.getType()).afterInvited(context);

            if (!message.isSuccess()) {
                log.warn("建立邀请关系失败，参数：{}，返回结果：{}", param, message);
                return;
            }
        }
        //绑定邀请关系
        this.bindUserInvite(param.getUserId());


        log.debug("用户建立邀请关系完成：{}", param);
    }

    private void bindUserInvite(Long userId) {
        UserInviteBindDTO userInviteBindDTO = new UserInviteBindDTO();
        userInviteBindDTO.setUserId(userId);
        userInviteBindDTO.setInviteBindMethodEnum(InviteBindMethodEnum.LOGIN_APP);
        // 绑定
        bindInviteManager.bindInvite(userInviteBindDTO);

        // 用户登录后将用户的师徒状态变更为正常
        getUserInviteService().changeHistoryStatus(userId, AppConst.USER_STATE.NORMAL);
    }

    @Override
    public String getFinalInviteTitle(UserInviteHistoryBean history) {
        return inviteTypeProcessorManager.obtain(history.getType()).decorateTitle(history);
    }

    @Override
    public String getLevelTwoFinalInviteTitle(Long userId, UserInviteHistoryBean history) {
        if (!Objects.equals(userId, history.getInviteUserId())) {
            return "来自" + userInfoCacheService.load(history.getInviteUserId()).getNickname() + this.getFinalInviteTitle(history);
        } else {
            return "来自你" + this.getFinalInviteTitle(history);
        }
    }

}
