package com.bxm.egg.user.invite.processor;

import com.bxm.egg.common.constant.InviteTypeEnum;
import com.bxm.egg.user.invite.InviteProcessorContext;
import com.bxm.egg.user.model.vo.UserInviteHistoryBean;
import com.bxm.newidea.component.bo.Message;
import org.springframework.stereotype.Component;

/**
 * 海报分享邀请的好友
 *
 * @author xujl
 * @date 2020-07-13 11:36:03
 */
@Component
public class PostersShareInviteTypeProcessor extends AbstractInviteTypeProcessor {
    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.POSTERS_SHARE;
    }

    @Override
    public String decorateTitle(UserInviteHistoryBean inviteHistory) {
        return "海报分享邀请";
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        return "海报分享";
    }


    @Override
    Message callback(InviteProcessorContext context) {
        return null;
    }
}
