package com.bxm.egg.user.login;

import com.bxm.egg.user.model.vo.UserLoginHistory;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.bo.Message;

public interface UserLoginHistoryService {

    /**
     * 保存用户在最后登录信息
     */
    void save(UserLoginHistory userLoginHistory);

    /**
     * 根据设备id（deviceId，IDFA，IMEI 判断用户是否在该设备上登录过）
     */
    Message isDeviceExist(Long userId, String deviceId);

    /**
     * 根据设备唯一id判断用户是否在设备上登录过
     */
    Message isDeviceExistByDeviceId(Long userId, String deviceId);

    /**
     * 异步增加用户的最后登录信息
     */
    void save(String equipment, BasicParam basicParam, Long userId, String ip);

    /**
     * 获取第一条登录记录
     *
     * @param userId userId
     * @return 第一条登录记录 如果不存在返回null
     */
    UserLoginHistory selectFirst(Long userId);

    /**
     * 获取最后一条登录记录
     *
     * @param userId userId
     * @return 最后一条登录记录 如果不存在返回null
     */
    UserLoginHistory selectLast(Long userId);
}
