package com.bxm.egg.user.medal.impl;

import com.bxm.egg.user.medal.UserMedalCounterService;
import com.bxm.egg.user.medal.strategy.MedalCounterStrategyManager;
import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * 用户勋章统计相关服务实现类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/3/6 10:35 上午
 */
@Service
@Slf4j
@AllArgsConstructor
public class UserMedalCounterServiceImpl implements UserMedalCounterService {

    private MedalCounterStrategyManager medalCounterStrategyManager;

    @Override
    public void handleMedalCounterData(UserMedalCounterDTO userMedalCounterDTO) {
        medalCounterStrategyManager.handleCounterData(userMedalCounterDTO);
    }
}