package com.bxm.egg.user.medal.impl;

import com.bxm.egg.user.info.UserInfoService;
import com.bxm.egg.user.mapper.medal.UserMedalRelationInfoMapper;
import com.bxm.egg.user.medal.UserMedalManageService;
import com.bxm.egg.user.medal.UserMedalService;
import com.bxm.egg.user.model.entity.UserInfoEntity;
import com.bxm.egg.user.model.vo.medal.manage.CustomMedalVO;
import com.bxm.egg.user.model.vo.medal.manage.UserMedalInfoVO;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/27 2:17 下午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserMedalManageServiceImpl implements UserMedalManageService {

    private final UserMedalRelationInfoMapper userMedalRelationInfoMapper;

    private final UserInfoService userInfoService;

    private final UserMedalService userMedalService;

    @Override
    public UserMedalInfoVO getUserMedalInfo(Long userId) {
        UserMedalInfoVO resultVO = new UserMedalInfoVO();

        UserInfoEntity currentUserInfo = userInfoService.selectAllUserById(userId);

        resultVO.setUserId(userId);
        resultVO.setPhone(currentUserInfo.getPhone());
        resultVO.setNickname(currentUserInfo.getNickname());

        //用户勋章总数
        resultVO.setMedalNum(userMedalService.getUserMedalNum(userId));

        //设置成就勋章数据
        resultVO.setAchievementMedalList(userMedalRelationInfoMapper.getUserAchievementMedalList(userId));

        //设置定制勋章数据
        List<CustomMedalVO> userCustomMedalList = userMedalRelationInfoMapper.getUserCustomMedalList(userId);
        for (CustomMedalVO customMedalVO : userCustomMedalList) {
            String grantTimeStr = DateUtils.formatDateTime(customMedalVO.getGrantTime());
            String expiredTimeStr = DateUtils.formatDateTime(customMedalVO.getExpiredTime());
            customMedalVO.setEffectiveRange(grantTimeStr + "-" + expiredTimeStr);
        }

        resultVO.setCustomMedalList(userCustomMedalList);

        return resultVO;
    }

}