package com.bxm.egg.user.medal.strategy;

import com.bxm.egg.user.model.dto.medal.UserMedalCounterDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * 勋章统计策略管理类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/3/6 11:34 上午
 */
@Slf4j
@Component
@AllArgsConstructor
public class MedalCounterStrategyManager {

    private List<AbstractMedalCounterStrategy> medalCounterStrategyList;

    public void handleCounterData(UserMedalCounterDTO userMedalCounterDTO) {
        AbstractMedalCounterStrategy targetStrategy = matchStrategy(userMedalCounterDTO);

        if (Objects.nonNull(targetStrategy)) {
            targetStrategy.handleData(userMedalCounterDTO);
        }

    }

    private AbstractMedalCounterStrategy matchStrategy(UserMedalCounterDTO userMedalCounterDTO) {
        for (AbstractMedalCounterStrategy medalCounterStrategy : medalCounterStrategyList) {
            if (log.isDebugEnabled()) {
                log.debug("勋章传入类型：{}, 勋章匹配的类型：{}", userMedalCounterDTO.getOperatorType(), medalCounterStrategy.counterType());
            }
            if (medalCounterStrategy.counterType().equals(userMedalCounterDTO.getOperatorType())) {
                return medalCounterStrategy;
            }
        }

        log.error("未匹配到勋章统计数据处理策略, ");
        return null;
    }
}