package com.bxm.egg.user.onekey.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.egg.user.onekey.JiGuangFlashService;
import com.bxm.egg.user.properties.CommonProperties;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

/**
 * 极光闪验service实现类
 *
 * @author wzy
 * @date 2021年10月07日11:00:04
 */
@Service
@Slf4j
public class JiGuangFlashServiceImpl implements JiGuangFlashService {

    private static final String SUCCESS_CODE = "8000";

    /**
     * 免密登录后台url
     */
    private static final String FLASH_LOGIN_URL = "https://api.verification.jpush.cn/v1/web/loginTokenVerify";

    @Resource
    private CommonProperties commonProperties;

    @Override
    public String getPhone(String loginToken) {

        log.info("请求闪验参数：[{}]", loginToken);

        if (StringUtils.isNotBlank(commonProperties.getJiGuangMockPhone())) {
            String phone = commonProperties.getJiGuangMockPhone();
            log.debug("研发环境，返回模拟的极光闪验手机号码:{}", phone);
            return phone;
        }

        JSONObject result = tokenExchangeMobileRequest(loginToken);
        log.info("闪验的返回结果，返回参数：{}", JSON.toJSONString(result));
        if (null == result) {
            log.warn("无法解析闪验的返回结果，请求参数：{}", loginToken);
            return null;
        }

        //返回码 8000为成功
        String code = result.getString("code");
        if (SUCCESS_CODE.equals(code)) {
            String secretPhone = result.getString("phone");
            String mobile;
            try {
                mobile = decrypt(secretPhone, commonProperties.getOneKeySecretKey());
                log.info("请求完成，请求参数：[{}],手机号码：[{}],返回值：[{}]", loginToken, mobile, result);
            } catch (Exception e) {
                log.error("解析闪验返回值错误，请求参数：[{}]，返回值：[{}]", loginToken, result);
                log.error(e.getMessage(), e);
                return null;
            }
            //解密后的手机号码
            return mobile;
        } else {
            log.error("极光闪验返回状态错误，请求参数：[{}]，返回值：[{}]", loginToken, result);
        }
        return null;
    }

    /**
     * 通过token换取手机号
     *
     * @param loginToken 入参
     * @return 返回结果
     */
    private JSONObject tokenExchangeMobileRequest(String loginToken) {
        try {
            Map<String, String> params = new HashMap<>();
            params.put("loginToken", loginToken);

            Map<String, String> headers = new HashMap<>();

            headers.put("Authorization", getAuthorizationContent());

            String jsonBody = OkHttpUtils.postJsonBody(FLASH_LOGIN_URL, JSON.toJSONString(params), headers);
            if (StringUtils.isNotBlank(jsonBody)) {
                return JSONObject.parseObject(jsonBody);
            }
        } catch (Exception e) {
            log.error("客户端请求参数：{}", loginToken);
            log.error(e.getMessage(), e);
        }

        return null;
    }

    /**
     * 获取认证头信息内容
     *
     * @return 认证头信息
     * @throws UnsupportedEncodingException 字符编码转化异常
     */
    private String getAuthorizationContent() throws UnsupportedEncodingException {
        String separator = ":";
        String baseStr = "Basic ";

        String appKey = commonProperties.getJiGuangAppKey();

        String masterSecret = commonProperties.getJiGuangMasterSecret();

        return baseStr + Base64.getEncoder()
                .encodeToString((appKey + separator + masterSecret).getBytes("utf-8"));
    }

    /**
     * 手机号码解密
     */
    private String decrypt(String secretContent, String prikey) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(prikey));
        PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(keySpec);

        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(Cipher.DECRYPT_MODE, privateKey);

        byte[] b = Base64.getDecoder().decode(secretContent);
        return new String(cipher.doFinal(b));
    }
}