package com.bxm.egg.user.register.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.mapper.UserRegisterLogMapper;
import com.bxm.egg.user.model.entity.UserRegisterLogEntity;
import com.bxm.egg.user.register.UserRegisterService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/26 7:46 下午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserRegisterServiceImpl implements UserRegisterService {

    @Resource
    private UserRegisterLogMapper userRegisterLogMapper;

    @Override
    public UserRegisterLogEntity selectByUserId(Long userId) {

        //查询注册信息
        LambdaQueryWrapper<UserRegisterLogEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(UserRegisterLogEntity::getUserId, userId);

        return userRegisterLogMapper.selectOne(queryWrapper);
    }
}