package com.bxm.egg.user.support.impl;

import com.bxm.egg.user.mapper.VirtualUserMapper;
import com.bxm.egg.user.model.dto.UserInfoDTO;
import com.bxm.egg.user.support.VirtualUserService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Log4j2
public class VirtualUserServiceImpl implements VirtualUserService {

    private final VirtualUserMapper userMapper;

    @Autowired
    public VirtualUserServiceImpl(VirtualUserMapper userMapper) {
        this.userMapper = userMapper;
    }

    @Override
    public List<UserInfoDTO> listVirtualUser(Integer num) {
        return userMapper.getVirtualUserList(num);
    }
}
