package com.bxm.egg.user.warmlevel.impl.callback;

import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;

/**
 * 账号处理过程中的回调接口，支持调用方在处理过程中进行额外的操作
 *
 * @author lowi
 * @date 2020/03/03
 */
public interface WarmActionCallback {

    /**
     * 账号处理之前
     */
    default void preAction(WarmActionContext context) {
    }

    /**
     * 账号信息处理之后
     */
    default void postAction(WarmActionContext context) {
    }

    /**
     * 处理失败后
     */
    default void failed(WarmActionContext context) {
    }

    /**
     * 发生异常时
     */
    default void exception(WarmActionContext context) {
    }

    /**
     * 每次重试之前
     */
    default void preRetry(WarmActionContext context) {
    }
}
