package com.bxm.egg.user.warmlevel.impl.handler;

import com.bxm.egg.user.facade.enums.WarmRuleEnum;
import com.bxm.egg.user.model.vo.warmlevel.WarmRuleDetail;
import com.bxm.egg.user.warmlevel.impl.context.WarmActionContext;
import com.bxm.egg.user.warmlevel.impl.rule.WarmRule;
import org.springframework.stereotype.Component;

/**
 * 增加用户可提现金额
 *
 * @author liujia
 * @date 2020/05/04 18:46
 */
@Component
public class MockActionHandler extends AbstractWarmActionHandler {


    @Override
    protected void afterPost(WarmActionContext context) {

    }

    @Override
    protected void execAction(WarmActionContext context) {
        WarmRuleDetail warmRuleDetail = new WarmRuleDetail();
        warmRuleDetail.setWarmValue(context.getOriginParam().getWarmValue());
        warmRuleDetail.setType(WarmRuleEnum.DEFAULT.name());
        warmRuleDetail.setTypeDesc("聪明善良的测试添加");
        context.setWarmRuleDetail(warmRuleDetail);

    }

    @Override
    public WarmRuleEnum support() {
        return WarmRuleEnum.DEFAULT;
    }

    @Override
    public Class<? extends WarmRule> bindRules() {
        return null;
    }
}
