package com.bxm.egg.user.account;

import com.bxm.egg.user.dto.LocationDTO;
import com.bxm.egg.user.model.dto.account.UserBaseAccountInfoDTO;
import com.bxm.egg.user.model.entity.UserAccountEntity;

/**
 * 用户账户service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/16 1:09 下午
 */
public interface UserAccountService {

    /**
     * 获取用户基础账户信息
     *
     * @param userId 用户id
     * @return 用户账户基本信息
     */
    UserBaseAccountInfoDTO baseInfo(Long userId);

    /**
     * 获取用户账户信息通过用户id
     *
     * @param userId 用户id
     * @return 用户账户信息
     */
    UserAccountEntity getUserAccountInfo(Long userId);

    /**
     * 操作鸡蛋接口
     *
     * @param userId 用户id
     * @param num    操作鸡蛋数量
     * @param type   操作类型0扣减，1增加
     * @return 是否成功
     */
    Boolean operateEgg(Long userId,
                       Integer num,
                       Integer type);

    /**
     * 操作粮食接口
     *
     * @param userId 用户id
     * @param num    操作粮食数量
     * @param type   操作类型0扣减，1增加
     * @return 是否成功
     */
    Boolean operateFoods(Long userId,
                         Integer num,
                         Integer type);

    /**
     * 操作粮食接口
     *
     * @param userId 用户id
     * @param locationDTO   地区
     */
    void updateSixEnjoyUserArea(Long userId,
                                LocationDTO locationDTO);
}