package com.bxm.egg.user.attribute;

import com.bxm.egg.user.model.dto.UserTagDTO;
import com.bxm.egg.user.model.vo.UserCommonTag;
import com.bxm.egg.user.model.vo.UserTag;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 用户标签服务
 *
 * @author wzy
 * @date 2021年09月16日12:19:02
 */
public interface UserTagService {

    /**
     * 用途：展示用户的所有标签，包括未选择的通用的标签和用户自定义标签 场景：用户在编辑个人资料时，点击标签可进入<我的标签>页面，显示标签列表
     *
     * @param userId 用户id
     * @return 标签列表
     */
    List<UserTagDTO> listUserTag(Long userId);

    /**
     * 用途：得到所有的默认标签，考虑到这玩意儿没有这么紧急，尽管后来要加，等个几个小时生效都无所谓吧...做二级缓存给别的方法调 场景：暂时没有
     *
     * @return 默认标签列表 获取用户的公共标签
     */
    List<UserCommonTag> listUserCommonTag();

    /**
     * 用途：得到用户的标签，先去缓存中取，没有的话去redis中 场景：主要给别的方法调用
     *
     * @param userId 用户id
     * @return 从redis里面返回用户标签信息
     */
    List<UserTag> getUserTagFromRedisDb(Long userId);

    /**
     * 转换实体，不解释
     *
     * @param userTag 源信息
     * @return 转换信息
     */
    UserTagDTO convertUserTag2UserTagDto(UserTag userTag);

    /**
     * 批量获取用户标签信息
     *
     * @param userIds 用户id集合
     * @return 用户标签信息
     */
    Map<Long, List<UserTag>> getBatchUserTag(Collection<Long> userIds);

}
