package com.bxm.egg.user.attribute.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.user.attribute.UserTagService;
import com.bxm.egg.user.constant.RedisConfig;
import com.bxm.egg.user.mapper.UserCommonTagMapper;
import com.bxm.egg.user.mapper.UserTagMapper;
import com.bxm.egg.user.model.dto.UserTagDTO;
import com.bxm.egg.user.model.vo.UserCommonTag;
import com.bxm.egg.user.model.vo.UserTag;
import com.bxm.egg.user.model.vo.UserTagRedis;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import lombok.AllArgsConstructor;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

import static com.alibaba.fastjson.JSON.parseObject;

@Service
@AllArgsConstructor
public class UserTagServiceImpl implements UserTagService {

    private final UserCommonTagMapper userCommonTagMapper;

    private final UserTagMapper userTagMapper;

    private final RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public List<UserTagDTO> listUserTag(Long userId) {

        //得到所有默认标签，做了二级缓存，应该很快的，不做异步了
        List<UserCommonTag> commonTagList = SpringContextHolder.getBean(this.getClass()).listUserCommonTag();

        //得到所有用户标签
        List<UserTag> userTagList = getUserTagFromRedisDb(userId);

        //标签列表返回体
        List<UserTagDTO> userTagDtoList = new ArrayList<>();

        //标签名称列表，用来去重的
        Set<String> labelList = new HashSet<>();

        //遍历用户标签列表，并封装结果
        userTagList.forEach(e -> {
            userTagDtoList.add(convertUserTag2UserTagDto(e));
            labelList.add(e.getLabel());
        });

        //遍历默认标签列表，加在用户标签的后面，根据标签名称去重
        commonTagList.forEach(e -> {
            if (!labelList.contains(e.getLabel())) {
                userTagDtoList.add(convertUserCommonTag2UserTagDto(e));
            }
        });

        return userTagDtoList;
    }

    /**
     * 用途如其名，不解释
     */
    @Override
    public UserTagDTO convertUserTag2UserTagDto(UserTag userTag) {
        UserTagDTO userTagDTO = new UserTagDTO();
        userTagDTO.setChooseFlag((byte) (userTag.getDeleteFlag() == 0 ? 1 : 0));
        userTagDTO.setDefaultFlag(userTag.getDefaultFlag());
        userTagDTO.setId(userTag.getId());
        userTagDTO.setLabel(userTag.getLabel());
        userTagDTO.setOrder(userTag.getOrder());
        return userTagDTO;
    }

    @Override
    public Map<Long, List<UserTag>> getBatchUserTag(Collection<Long> userIds) {
        Map<Long, List<UserTag>> userTagMap = new HashMap<>();
        List<String> paramList = userIds.stream().map(String::valueOf).collect(Collectors.toList());
        List<String> userTagCaches = redisHashMapAdapter.multiGet(RedisConfig.USER_TAG, paramList, String.class);
        userTagCaches.forEach(e -> {
            UserTagRedis userTagRedis = parseObject(e, UserTagRedis.class);
            if (null != userTagRedis) {
                userTagMap.put(userTagRedis.getUserId(), userTagRedis.getUserTagList());
            }
        });
        return userTagMap;
    }


    /**
     * 用途如其名，不解释
     */

    private UserTagDTO convertUserCommonTag2UserTagDto(UserCommonTag userTag) {
        UserTagDTO userTagDTO = new UserTagDTO();
        userTagDTO.setChooseFlag((byte) 0);
        userTagDTO.setDefaultFlag((byte) 1);
        userTagDTO.setId(userTag.getId());
        userTagDTO.setLabel(userTag.getLabel());
        return userTagDTO;
    }

    @Override
    @Cacheable(value = "listUserCommonTag", sync = true)
    public List<UserCommonTag> listUserCommonTag() {
        return userCommonTagMapper.selectAll();
    }

    @Override
    public List<UserTag> getUserTagFromRedisDb(Long userId) {
        List<UserTag> userTagList;
        //获取用户的所有标签
        String userTagStr = this.redisHashMapAdapter.get(RedisConfig.USER_TAG, String.valueOf(userId), String.class);
        //如果缓存有值
        if (!StringUtils.isEmpty(userTagStr)) {
            UserTagRedis userTagRedis = parseObject(userTagStr, UserTagRedis.class);
            userTagList = userTagRedis.getUserTagList();
        } else {
            UserTagRedis userTagRedis;
            userTagList = this.userTagMapper.selectByUserId(userId);
            if (CollectionUtils.isEmpty(userTagList)) {
                //如果没有的话，就塞个空的数组进redis中，防止恶意请求不存在的用户id导致【缓存穿透】
                userTagRedis = UserTagRedis.buildEmptyUserTagRedis(userId);
            } else {
                userTagRedis = UserTagRedis.buildUserTagRedis(userId, userTagList);
            }
            this.redisHashMapAdapter.put(RedisConfig.USER_TAG, String.valueOf(userId), JSON.toJSONString(userTagRedis));
        }
        return userTagList;
    }

}
