package com.bxm.egg.user.auth;

import com.bxm.egg.user.model.entity.UserBlockExpiredTaskEntity;

import java.util.Date;
import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/17 5:23 下午
 */
public interface UserBlockExpiredTaskService {

    /**
     * 添加任务
     *
     * @param userId      用户id
     * @param index       权限列表
     * @param expiredTime 过期时间
     */
    void addTask(Long userId, List<Integer> index, Date expiredTime);


    /**
     * 移除任务
     *
     * @param userId 用户id
     */
    void removeTask(Long userId);


    /**
     * 获取已经过期要执行的任务
     *
     * @return 任务列表
     */
    List<UserBlockExpiredTaskEntity> getExpiredTaskList();
}