package com.bxm.egg.user.constant;

import com.bxm.egg.user.location.rule.ActualLocationRule;
import com.bxm.egg.user.location.rule.ForceLocationRule;
import com.bxm.egg.user.location.rule.HistoryLocationRule;
import com.bxm.egg.user.location.rule.InviteLocationRule;

import java.util.HashMap;
import java.util.Map;

/**
 * 排序统一定义，方便调整
 * 排序可能涉及到变量的变更，修改时请谨慎阅读过滤器的内部逻辑
 *
 * @author liujia
 * @date 1/14/21 9:43 AM
 **/
public class OrderConstant {
    private OrderConstant() {
    }

    private static Map<Class<?>, Integer> orderMap = new HashMap<>();

    public static Integer getOrder(Class<?> clasz) {
        Integer order = orderMap.get(clasz);
        if (order == null) {
            return 0;
        }
        return order;
    }

    static {
        int order = 0;

        // 用户定位规则逻辑顺序
        orderMap.put(HistoryLocationRule.class, ++order);
        orderMap.put(InviteLocationRule.class, ++order);
        orderMap.put(ActualLocationRule.class, ++order);
        orderMap.put(ForceLocationRule.class, ++order);

    }
}
