package com.bxm.egg.user.constant;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/14 2:26 下午
 */
public enum UserStateEnum {
    /**
     * 静默用户，用户没有登录行为产生的用户
     */
    MUTE(0),

    /**
     * 有效用户
     */
    NORMAL(1),

    /**
     * 未激活的用户，在应用外进行创建的用户
     */
    NOT_ACTIVATED(2),

    /**
     * 虚拟用户
     */
    VIRTUAL(8),

    /**
     * 屏蔽用户，有恶意行为的用户ID
     */
    BLACK(9);

    private int code;

    UserStateEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static UserStateEnum get(int code) {
        for (UserStateEnum stateEnum : UserStateEnum.values()) {
            if (stateEnum.getCode() == code) {
                return stateEnum;
            }
        }

        return null;
    }

    public boolean equalsCode(int code) {
        return this.getCode() == code;
    }
}