package com.bxm.egg.user.facade;

import com.bxm.egg.user.auth.UserAuthCodeService;
import com.bxm.egg.user.facade.dto.UserAuthCodeDTO;
import com.bxm.egg.user.facade.service.UserAuthFacadeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;

import javax.annotation.Resource;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/17 4:06 下午
 */
@DubboService(protocol = {"dubbo"}, version = "1.0.0")
@Slf4j
public class UserAuthFacadeServiceImpl implements UserAuthFacadeService {

    @Resource
    private UserAuthCodeService userAuthCodeService;

    @Override
    public UserAuthCodeDTO getUserAuth(Long userId) {

        return UserAuthCodeDTO.builder()
                .authResources(userAuthCodeService.getAuthResources(userId))
                .combineAuthCode(userAuthCodeService.getAuthCombineCode(userId))
                .build();
    }
}