package com.bxm.egg.user.facade;

import com.bxm.egg.user.account.UserAccountService;
import com.bxm.egg.user.facade.dto.UserAccountEggNumDTO;
import com.bxm.egg.user.facade.enums.OperateTypeEnum;
import com.bxm.egg.user.facade.param.UserEggOperateEggParam;
import com.bxm.egg.user.facade.param.UserEggOperateFoodsParam;
import com.bxm.egg.user.facade.service.UserEggAccountFacadeService;
import com.bxm.egg.user.info.UserBaseInfoService;
import com.bxm.egg.user.integration.sync.SixEnjoyUserAccountIntegrationService;
import com.bxm.egg.user.model.dto.info.UserBriefInfoDTO;
import com.bxm.egg.user.model.entity.UserAccountEntity;
import com.bxm.newidea.component.bo.Message;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;

import javax.annotation.Resource;

/**
 * 用户账户内部服务实现
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/28 6:13 下午
 */
@DubboService(protocol = {"dubbo"}, version = "1.0.0")
@Slf4j
public class UserEggAccountFacadeServiceImpl implements UserEggAccountFacadeService {

    @Resource
    private UserAccountService userAccountService;

    @Resource
    private UserBaseInfoService userBaseInfoService;

    @Resource
    private SixEnjoyUserAccountIntegrationService sixEnjoyUserAccountIntegrationService;

    @Override
    public Message operateFoods(UserEggOperateFoodsParam param) {

        if (OperateTypeEnum.INCREASE.equals(param.getOperateTypeEnum())) {
            Boolean result = sixEnjoyUserAccountIntegrationService.addFoodsNum(param.getUserId(),
                    param.getGoodsNum(), param.getRemark());
            return Message.build(result);
        } else if (OperateTypeEnum.REDUCE.equals(param.getOperateTypeEnum())) {
            UserAccountEntity userAccountInfo = userAccountService.getUserAccountInfo(param.getUserId());

            if (userAccountInfo == null) {
                return Message.build(false, "用户账户信息不存在");
            }

            if (userAccountInfo.getUsableFoods() < param.getGoodsNum()) {
                return Message.build(false, "用户粮食不足");
            }
            Boolean result = sixEnjoyUserAccountIntegrationService.subFoodsNum(param.getUserId(),
                    param.getGoodsNum(), param.getRemark());

            return Message.build(result);
        }
        return Message.build(false, "操作类型不存在");
    }

    @Override
    public Message operateEgg(UserEggOperateEggParam param) {
        if (OperateTypeEnum.INCREASE.equals(param.getOperateTypeEnum())) {
            Boolean result = sixEnjoyUserAccountIntegrationService.addEggsNum(param.getUserId(),
                    param.getEggNum(), param.getRemark());
            return Message.build(result);
        } else if (OperateTypeEnum.REDUCE.equals(param.getOperateTypeEnum())) {
            UserAccountEntity userAccountInfo = userAccountService.getUserAccountInfo(param.getUserId());

            if (userAccountInfo == null) {
                return Message.build(false, "用户账户信息不存在");
            }

            if (userAccountInfo.getUsableEgg() < param.getEggNum()) {
                return Message.build(false, "用户鸡蛋不足");
            }
            Boolean result = sixEnjoyUserAccountIntegrationService.subEggsNum(param.getUserId(),
                    param.getEggNum(), param.getRemark());

            return Message.build(result);
        }
        return Message.build(false, "操作类型不存在");
    }

    @Override
    public UserAccountEggNumDTO getUserAccountEggNum(Long userId) {
        UserBriefInfoDTO singleUserBriefInfo = userBaseInfoService.getSingleUserBriefInfo(userId);
        UserAccountEntity userAccountInfo = userAccountService.getUserAccountInfo(userId);
        return UserAccountEggNumDTO.builder()
                .userId(userId)
                .eggNums(userAccountInfo.getUsableEgg())
                .headImg(singleUserBriefInfo.getHeadImg())
                .build();
    }
}