package com.bxm.egg.user.info.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.egg.user.facade.param.UserStatisticsOperateParam;
import com.bxm.egg.user.info.UserStatisticsService;
import com.bxm.egg.user.mapper.UserStatisticsMapper;
import com.bxm.egg.user.model.entity.UserStatisticsEntity;
import com.bxm.newidea.component.bo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/17 5:37 下午
 */
@Slf4j
@Service
@AllArgsConstructor
public class UserStatisticsServiceImpl implements UserStatisticsService {

    private final UserStatisticsMapper userStatisticsMapper;

    @Override
    public UserStatisticsEntity selectUserStatisticsByUserId(Long userId) {
        LambdaQueryWrapper<UserStatisticsEntity> queryWrapper = new LambdaQueryWrapper<>();

        queryWrapper.eq(UserStatisticsEntity::getUserId, userId);

        UserStatisticsEntity userStatisticsEntity = userStatisticsMapper.selectOne(queryWrapper);

        if (userStatisticsEntity == null) {
            return buildValidUserStatistics(userId);
        }

        return userStatisticsEntity;
    }

    private UserStatisticsEntity buildValidUserStatistics(Long userId) {

        UserStatisticsEntity userStatisticsEntity = new UserStatisticsEntity();
        userStatisticsEntity.setId(0L);
        userStatisticsEntity.setUserId(userId);
        userStatisticsEntity.setPostNum(0);
        userStatisticsEntity.setReplyNum(0);
        userStatisticsEntity.setAttentionNum(0);
        userStatisticsEntity.setFanNum(0);
        userStatisticsEntity.setLikeNum(0);
        userStatisticsEntity.setSignNum(0);
        userStatisticsEntity.setMaxSignNum(0);
        userStatisticsEntity.setWarmValue(0);
        userStatisticsEntity.setCreateTime(LocalDateTime.now());
        userStatisticsEntity.setModifyTime(LocalDateTime.now());

        return userStatisticsEntity;
    }

    @Override
    public int updateUserWarmInfo(Long userId, Integer warmValue, Integer defaultWarmValue) {
        return userStatisticsMapper.updateUserWarmInfo(userId, warmValue, defaultWarmValue);
    }

    @Override
    public Message operateUserStatistics(UserStatisticsOperateParam param) {

        int result = userStatisticsMapper.operateUserStatistics(param.getUserId(),
                param.getUserStatisticsType().getCode(),
                param.getOperateTypeEnum().getCode(),
                param.getOperateNum());

        if (result > 0) {
            return Message.build(true);
        }
        return Message.build(false, "更新失败");
    }
}